/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class RegistryGroupEnvironment<T>
extends AbstractEnvironment {
    private final AbstractConfigField FIELD;
    protected final boolean INVERT;
    private final String NAMESPACE;
    private List<T> registryEntries;

    public RegistryGroupEnvironment(ResourceLocation regKey, boolean invert) {
        this.FIELD = null;
        this.INVERT = invert;
        this.NAMESPACE = regKey.toString();
    }

    public RegistryGroupEnvironment(AbstractConfigField field, String line) {
        this.FIELD = field;
        this.INVERT = line.startsWith("!");
        this.NAMESPACE = line.substring(this.INVERT ? 1 : 0, line.length() - 1);
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + this.NAMESPACE + "*";
    }

    public abstract IForgeRegistry<T> getRegistry();

    protected final List<T> getRegistryEntries() {
        if (this.registryEntries == null) {
            this.registryEntries = new ArrayList<T>();
            for (ResourceLocation regKey : this.getRegistry().getKeys()) {
                Object entry;
                if (!regKey.toString().startsWith(this.NAMESPACE) || (entry = this.getRegistry().getValue(regKey)) == null) continue;
                this.registryEntries.add(entry);
            }
            if (this.registryEntries.isEmpty()) {
                ConfigUtil.LOG.warn("Namespace entry for {} \"{}\" did not match anything in registry \"{}\"! Questionable entry: {}", this.FIELD == null ? "DEFAULT" : this.FIELD.getClass(), (Object)(this.FIELD == null ? "DEFAULT" : this.FIELD.getKey()), (Object)this.getRegistry().getRegistryName(), (Object)this.NAMESPACE);
            }
            this.registryEntries = Collections.unmodifiableList(this.registryEntries);
        }
        return this.registryEntries;
    }
}

