/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public abstract class RegistryEnvironment<T>
extends AbstractEnvironment {
    private final AbstractConfigField FIELD;
    protected final boolean INVERT;
    private final ResourceLocation REGISTRY_KEY;
    private T registryEntry;

    public RegistryEnvironment(ResourceLocation registryKey, boolean invert) {
        this.FIELD = null;
        this.INVERT = invert;
        this.REGISTRY_KEY = registryKey;
    }

    public RegistryEnvironment(AbstractConfigField field, String line) {
        this.FIELD = field;
        this.INVERT = line.startsWith("!");
        this.REGISTRY_KEY = ResourceLocation.parse((String)(this.INVERT ? line.substring(1) : line));
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + this.REGISTRY_KEY.toString();
    }

    public abstract IForgeRegistry<T> getRegistry();

    @Nullable
    protected final T getRegistryEntry() {
        if (this.registryEntry == null) {
            if (!this.getRegistry().containsKey(this.REGISTRY_KEY)) {
                ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Not present in registry \"{}\". Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.getRegistry().getRegistryName(), (Object)this.REGISTRY_KEY);
            }
            this.registryEntry = this.getRegistry().getValue(this.REGISTRY_KEY);
        }
        return this.registryEntry;
    }
}

