/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import fathertoast.crust.api.config.common.value.environment.ComparisonOperator;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeCategoryEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeGroupEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeTagEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeTemperatureEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.RainfallEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.TemperatureEnvironment;
import fathertoast.crust.api.config.common.value.environment.compat.ApocalypseDifficultyEnvironment;
import fathertoast.crust.api.config.common.value.environment.compat.ApocalypseDifficultyOrTimeEnvironment;
import fathertoast.crust.api.config.common.value.environment.dimension.DimensionPropertyEnvironment;
import fathertoast.crust.api.config.common.value.environment.dimension.DimensionTypeEnvironment;
import fathertoast.crust.api.config.common.value.environment.dimension.DimensionTypeGroupEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.PositionEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.StructureEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.StructureGroupEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.YEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.YFromSeaEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.ChunkTimeEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.DayTimeEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.DifficultyEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.MoonBrightnessEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.MoonPhaseEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.SpecialDifficultyEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.TimeFromMidnightEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.WeatherEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.WorldTimeEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class CrustEnvironmentRegistry {
    private static final Map<String, IFactory> NAME_TO_FACTORY_MAP = new HashMap<String, IFactory>();
    private static final Set<String> NAME_SET = Collections.unmodifiableSet(NAME_TO_FACTORY_MAP.keySet());
    private static final Map<Class<? extends AbstractEnvironment>, String> CLASS_TO_NAME_MAP = new HashMap<Class<? extends AbstractEnvironment>, String>();
    private static final List<String> DESCRIPTIONS;

    public static String register(String name, IFactory factory, Class<? extends AbstractEnvironment> type, String format, String ... description) {
        return CrustEnvironmentRegistry.register(name, factory, Collections.singletonList(type), format, description);
    }

    public static String register(String name, IFactory factory, List<Class<? extends AbstractEnvironment>> types, String format, String ... description) {
        if (NAME_TO_FACTORY_MAP.containsKey(name = name.toLowerCase(Locale.ROOT).replace(' ', '_'))) {
            throw new IllegalStateException("Duplicate environment names cannot be registered! Duplicate name: " + name);
        }
        if (name.equals("null")) {
            throw new IllegalArgumentException("Invalid environment name: " + name);
        }
        NAME_TO_FACTORY_MAP.put(name, factory);
        for (Class<? extends AbstractEnvironment> type : types) {
            if (CLASS_TO_NAME_MAP.containsKey(type)) {
                throw new IllegalStateException("Classes cannot be registered to multiple environment names! Class: " + type);
            }
            CLASS_TO_NAME_MAP.put(type, name);
        }
        DESCRIPTIONS.add("");
        if (description.length > 0) {
            DESCRIPTIONS.add("  \"" + name + " " + format + "\":");
            for (String line : description) {
                DESCRIPTIONS.add("    " + line);
            }
        } else {
            DESCRIPTIONS.add("  \"" + name + " " + format + "\"");
        }
        return name;
    }

    public static AbstractEnvironment parse(AbstractConfigField field, String name, String value) {
        IFactory factory = NAME_TO_FACTORY_MAP.get(name.toLowerCase(Locale.ROOT));
        if (factory == null) {
            WorldTimeEnvironment fallback = new WorldTimeEnvironment(ComparisonOperator.LESS_THAN, 0L);
            ConfigUtil.LOG.warn("Invalid environment '{}' for {} \"{}\"! Falling back to \"{}\". Environment name must be in the set [ {} ]. Invalid environment: {}", (Object)name, field.getClass(), (Object)field.getKey(), (Object)fallback, (Object)TomlHelper.toLiteralList(CrustEnvironmentRegistry.getNames().toArray(new String[0])), (Object)value);
            return fallback;
        }
        return factory.parse(field, value);
    }

    public static Set<String> getNames() {
        return NAME_SET;
    }

    @Nullable
    public static String getName(AbstractEnvironment environment) {
        return CrustEnvironmentRegistry.getName(environment.getClass());
    }

    @Nullable
    public static String getName(Class<? extends AbstractEnvironment> type) {
        return CLASS_TO_NAME_MAP.get(type);
    }

    public static List<String> getDescriptions() {
        return Collections.unmodifiableList(DESCRIPTIONS);
    }

    static {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Environment conditions (for Environment List entries):");
        comment.add("  Many environment conditions can be inverted by using \"!\"; these are shown with (!) in the appropriate location.");
        comment.add("  Other environment conditions are numerical comparisons; these use the operators (shown as op) <, >, =, <=, >=, or != to compare value.");
        comment.add("");
        comment.add("Valid environment conditions are:");
        DESCRIPTIONS = comment;
        CrustEnvironmentRegistry.register("dimension_property", DimensionPropertyEnvironment::new, DimensionPropertyEnvironment.class, "(!)property", "Valid property values: " + TomlHelper.toLiteralList((Object[])DimensionPropertyEnvironment.Value.values()), "Dimension properties are the true/false values available to dimension types in data packs. See the wiki for more info: [https://minecraft.fandom.com/wiki/Custom_dimension#Syntax].");
        CrustEnvironmentRegistry.register("dimension_type", (AbstractConfigField field, String value) -> value.endsWith("*") ? new DimensionTypeGroupEnvironment(field, value) : new DimensionTypeEnvironment(field, value), Arrays.asList(DimensionTypeGroupEnvironment.class, DimensionTypeEnvironment.class), "(!)namespace:dimension_type_name", "The world's dimension type. In vanilla, these are only \"minecraft:overworld\", \"minecraft:the_nether\", or \"minecraft:the_end\".");
        CrustEnvironmentRegistry.register("rainfall", RainfallEnvironment::new, RainfallEnvironment.class, "op value", "Biome's rainfall parameter. If this is \"= 0\", it checks that rain is disabled. For reference, rainfall > 0.85 suppresses fire.");
        CrustEnvironmentRegistry.register("biome_temp", BiomeTemperatureEnvironment::new, BiomeTemperatureEnvironment.class, "op value OR (!)freezing", "Biome's temperature parameter. For reference, freezing is < 0.15 and hot is generally considered > 0.95.");
        CrustEnvironmentRegistry.register("temp", TemperatureEnvironment::new, TemperatureEnvironment.class, "op value OR (!)freezing", "Height-adjusted temperature. For reference, freezing is < 0.15 and hot is generally considered > 0.95.");
        CrustEnvironmentRegistry.register("biome_category", BiomeCategoryEnvironment::new, BiomeCategoryEnvironment.class, "(!)category", "Deprecated, use \"biome_tag\" instead!");
        CrustEnvironmentRegistry.register("biome_tag", BiomeTagEnvironment::new, BiomeTagEnvironment.class, "(!)#namespace:biome_tag", "The biome tag. See the wiki for vanilla biome tags (resource locations) [https://minecraft.wiki/w/Biome_tag_(Java_Edition)].");
        CrustEnvironmentRegistry.register("biome", (AbstractConfigField field, String value) -> value.endsWith("*") ? new BiomeGroupEnvironment(field, value) : new BiomeEnvironment(field, value), Arrays.asList(BiomeGroupEnvironment.class, BiomeEnvironment.class), "(!)namespace:biome_name", "The biome. See the wiki for vanilla biome names (resource locations) [https://minecraft.fandom.com/wiki/Biome#Biome_IDs].");
        CrustEnvironmentRegistry.register("structure", (AbstractConfigField field, String value) -> value.endsWith("*") ? new StructureGroupEnvironment(field, value) : new StructureEnvironment(field, value), Arrays.asList(StructureGroupEnvironment.class, StructureEnvironment.class), "(!)namespace:structure_name", "The structure. See the wiki for vanilla structure names [https://minecraft.fandom.com/wiki/Structure#ID].");
        CrustEnvironmentRegistry.register("y", YEnvironment::new, YEnvironment.class, "op value", "The y-value. For reference, sea level is normally 63 and lava level is normally -54.");
        CrustEnvironmentRegistry.register("y_from_sea", YFromSeaEnvironment::new, YFromSeaEnvironment.class, "op value", "The y-value from sea level. Expect the only air < 0 to be in caves/ravines (which may still have direct view of the sky).");
        CrustEnvironmentRegistry.register("position", PositionEnvironment::new, PositionEnvironment.class, "(!)state", "Valid state values: " + TomlHelper.toLiteralList((Object[])PositionEnvironment.Value.values()), "Miscellaneous conditions that generally do what you expect. For reference, 'near' a village is ~3 chunks, and redstone checks weak power.");
        CrustEnvironmentRegistry.register("difficulty", DifficultyEnvironment::new, DifficultyEnvironment.class, "op value", "The regional difficulty (0 to 6.75). This is based on many factors such as difficulty setting, moon brightness, chunk inhabited time, and world time.", "For reference, this scales up to the max after 63 days in the world and 150 days in a particular chunk, and peaks during full moons. On Peaceful this is always 0, on Easy this is 0.75 to 1.5, on Normal this is 1.5 to 4.0, and on Hard this is 2.25 to 6.75.");
        CrustEnvironmentRegistry.register("special_difficulty", SpecialDifficultyEnvironment::new, SpecialDifficultyEnvironment.class, "op value", "The 'special multiplier' for regional difficulty (0 to 1). For reference, this is 0 when difficulty <= 2 and 1 when difficulty >= 4.", "This is always 0 in Easy and below. In Normal, it maxes at absolute peak regional difficulty. In Hard, it starts at 0.125 and maxes out in ~50 days.");
        CrustEnvironmentRegistry.register("weather", WeatherEnvironment::new, WeatherEnvironment.class, "(!)type", "Valid type values: " + TomlHelper.toLiteralList((Object[])WeatherEnvironment.Value.values()));
        CrustEnvironmentRegistry.register("moon_brightness", MoonBrightnessEnvironment::new, MoonBrightnessEnvironment.class, "op value", "The moon brightness (0 to 1). New moon has 0 brightness, full moon has 1 brightness. Intermediate phases are 0.25, 0.5, or 0.75.");
        CrustEnvironmentRegistry.register("moon_phase", MoonPhaseEnvironment::new, MoonPhaseEnvironment.class, "(!)phase", "Valid phase values: " + TomlHelper.toLiteralList((Object[])MoonPhaseEnvironment.Value.values()), "For reference, the first day in a new world is always a full moon.");
        CrustEnvironmentRegistry.register("day_time", DayTimeEnvironment::new, DayTimeEnvironment.class, "(!)time", "Valid time values: " + TomlHelper.toLiteralList((Object[])DayTimeEnvironment.Value.values()), "Note that the transition periods, sunset & sunrise, are considered as part of day & night, respectively.");
        CrustEnvironmentRegistry.register("time_from_midnight", TimeFromMidnightEnvironment::new, TimeFromMidnightEnvironment.class, "op value", "The absolute time in ticks away from midnight. Value must be 0 to 12000.");
        CrustEnvironmentRegistry.register("world_time", WorldTimeEnvironment::new, WorldTimeEnvironment.class, "op value", "The total time the world has existed, in ticks. For reference, each day cycle is 24000 ticks and each lunar cycle is 192000 ticks.");
        CrustEnvironmentRegistry.register("chunk_time", ChunkTimeEnvironment::new, ChunkTimeEnvironment.class, "op value", "The total time the chunk has been loaded, in ticks. For reference, each day cycle is 24000 ticks and each lunar cycle is 192000 ticks.");
        CrustEnvironmentRegistry.register("apocalypse_difficulty", ApocalypseDifficultyEnvironment::new, ApocalypseDifficultyEnvironment.class, "op value", "The Apocalypse Rebooted mod's difficulty (scale depends on your config). This is based on the nearest player's current difficulty level. If no player exists, or the mod is not installed, it will never match any condition.");
        CrustEnvironmentRegistry.register("apocalypse_difficulty_or_time", ApocalypseDifficultyOrTimeEnvironment::new, ApocalypseDifficultyOrTimeEnvironment.class, "op value", "The Apocalypse Rebooted mod's difficulty (scale depends on your config). If the mod is not installed, this is instead treated like a \"" + CrustEnvironmentRegistry.getName(WorldTimeEnvironment.class) + "\" condition.");
    }

    public static interface IFactory {
        public AbstractEnvironment parse(AbstractConfigField var1, String var2);
    }
}

