/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryValueEntry<T> {
    private final AbstractConfigField FIELD;
    public final ResourceLocation REG_KEY;
    public final double[] VALUES;

    public RegistryValueEntry(ResourceLocation regKey, double ... values) {
        this(null, regKey, values);
    }

    public RegistryValueEntry(@Nullable AbstractConfigField field, ResourceLocation regKey, double ... values) {
        this.FIELD = field;
        this.REG_KEY = regKey;
        this.VALUES = values;
    }

    private boolean validate(IForgeRegistry<T> registry) {
        if (this.REG_KEY == null || !registry.containsKey(this.REG_KEY)) {
            ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)(this.REG_KEY == null ? "null" : this.REG_KEY.toString()));
            return false;
        }
        return true;
    }

    public boolean contains(IForgeRegistry<T> registry, RegistryValueEntry<T> entry) {
        if (!this.validate(registry)) {
            return false;
        }
        return entry.REG_KEY.equals((Object)this.REG_KEY);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.REG_KEY.toString());
        if (this.VALUES != null && this.VALUES.length > 0) {
            for (double value : this.VALUES) {
                str.append(' ').append(value);
            }
        }
        return str.toString();
    }
}

