/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.RegistryEntryList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class LazyRegistryEntryList<T>
extends RegistryEntryList<T> {
    private final AbstractConfigField FIELD;
    private boolean populated;

    @Deprecated(forRemoval=true)
    public LazyRegistryEntryList(IForgeRegistry<T> registry, List<T> entries) {
        this(registry, entries.toArray());
    }

    @SafeVarargs
    public LazyRegistryEntryList(IForgeRegistry<T> registry, T ... entries) {
        this(registry, null, null, entries);
    }

    public LazyRegistryEntryList(IForgeRegistry<T> registry, @Nullable List<String> namespaces, @Nullable List<TagKey<T>> tags, T ... entries) {
        super(registry, namespaces, tags, entries);
        this.FIELD = null;
        this.populated = true;
    }

    public LazyRegistryEntryList(IForgeRegistry<T> registry, boolean ignored, Object ... entries) {
        super(registry);
        this.FIELD = null;
        if (entries.length > 0) {
            for (Object entry : entries) {
                if (registry.containsValue(entry)) {
                    ResourceLocation regKey = registry.getKey(entry);
                    if (regKey == null) {
                        throw new IllegalArgumentException("Invalid default lazy registry list entry! " + entry);
                    }
                    this.PRINT_LIST.add(regKey.toString());
                    continue;
                }
                if (entry instanceof TagKey) {
                    this.PRINT_LIST.add(ConfigUtil.toString((TagKey)entry));
                    continue;
                }
                if (entry instanceof RegistryObject) {
                    this.PRINT_LIST.add(((RegistryObject)entry).getId().toString());
                    continue;
                }
                if (entry instanceof ResourceLocation) {
                    this.PRINT_LIST.add(entry.toString());
                    continue;
                }
                if (entry instanceof String) {
                    this.PRINT_LIST.add((String)entry);
                    continue;
                }
                if (entry instanceof Boolean) continue;
                throw new IllegalArgumentException("Invalid default lazy registry list entry! " + entry);
            }
        }
    }

    public LazyRegistryEntryList(AbstractConfigField field, IForgeRegistry<T> registry, List<String> entries) {
        super(registry);
        this.FIELD = field;
        for (String line : entries) {
            if (line.startsWith("#")) {
                ResourceLocation tagLocation = ResourceLocation.m_135820_((String)line.substring(1));
                if (tagLocation == null) {
                    ConfigUtil.LOG.warn("Invalid tag key for {} \"{}\"! Skipping tag. Invalid tag key: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                    continue;
                }
                this.tag(new TagKey(registry.getRegistryKey(), tagLocation));
                continue;
            }
            if (line.endsWith("*")) {
                String[] parts = line.split(":");
                if (parts[0].isEmpty()) {
                    ConfigUtil.LOG.warn("Invalid namespace entry for {} \"{}\"! Skipping. Invalid namespace entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                    continue;
                }
                this.namespace(parts[0]);
                continue;
            }
            this.PRINT_LIST.add(ResourceLocation.parse((String)line).toString());
        }
    }

    private void populateEntries() {
        if (this.populated) {
            return;
        }
        this.populated = true;
        for (String line : this.PRINT_LIST) {
            ResourceLocation regKey;
            if (line.startsWith("#") || line.endsWith("*") || this.mergeFrom(regKey = ResourceLocation.parse((String)line))) continue;
            ConfigUtil.LOG.warn("Invalid or duplicate entry for {} \"{}\"! Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)line);
        }
    }

    @Override
    public Set<T> getEntries() {
        this.populateEntries();
        return super.getEntries();
    }

    @Override
    public boolean isEmpty() {
        return this.populated ? super.isEmpty() : this.PRINT_LIST.isEmpty();
    }

    @Override
    public boolean contains(@Nullable T entry) {
        this.populateEntries();
        return super.contains(entry);
    }

    @Override
    public boolean containsOrTag(@Nullable T entry, Predicate<TagKey<T>> tagPredicate) {
        this.populateEntries();
        return super.containsOrTag(entry, tagPredicate);
    }
}

