/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.IStringArray;
import fathertoast.crust.api.lib.EnvironmentHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class EnvironmentList
implements IStringArray {
    private final EnvironmentEntry[] ENTRIES;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    public EnvironmentList(List<EnvironmentEntry> entries) {
        this(entries.toArray(new EnvironmentEntry[0]));
    }

    public EnvironmentList(EnvironmentEntry ... entries) {
        this.ENTRIES = entries;
    }

    public String toString() {
        return TomlHelper.toLiteral(this.toStringList().toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EnvironmentList)) {
            return false;
        }
        return this.toStringList().equals(((EnvironmentList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.ENTRIES.length);
        for (EnvironmentEntry entry : this.ENTRIES) {
            list.add(entry.toString());
        }
        return list;
    }

    public double getOrElse(Level world, DoubleField defaultValue) {
        return this.unsafeGetOrElse(world, null, defaultValue);
    }

    public double getOrElse(Level world, double defaultValue) {
        return this.unsafeGetOrElse(world, null, defaultValue);
    }

    @Nullable
    public Double get(Level world) {
        return this.unsafeGet(world, null);
    }

    public double getOrElse(Level world, @Nullable BlockPos pos, DoubleField defaultValue) {
        this.validatePos(world, pos);
        return this.unsafeGetOrElse(world, pos, defaultValue);
    }

    public double getOrElse(Level world, @Nullable BlockPos pos, double defaultValue) {
        this.validatePos(world, pos);
        return this.unsafeGetOrElse(world, pos, defaultValue);
    }

    @Nullable
    public Double get(Level world, @Nullable BlockPos pos) {
        this.validatePos(world, pos);
        return this.unsafeGet(world, pos);
    }

    private void validatePos(Level world, @Nullable BlockPos pos) {
        if (pos != null && !EnvironmentHelper.isLoaded((LevelAccessor)world, pos)) {
            throw new IllegalStateException("Attempted to query world data in an unloaded chunk. This is bad!");
        }
    }

    private double unsafeGetOrElse(Level world, @Nullable BlockPos pos, DoubleField defaultValue) {
        return this.unsafeGetOrElse(world, pos, defaultValue.get());
    }

    private double unsafeGetOrElse(Level world, @Nullable BlockPos pos, double defaultValue) {
        Double value = this.unsafeGet(world, pos);
        return value == null ? defaultValue : value;
    }

    @Nullable
    private Double unsafeGet(Level world, @Nullable BlockPos pos) {
        for (EnvironmentEntry entry : this.ENTRIES) {
            if (!entry.unsafeMatches(world, pos)) continue;
            return entry.VALUE;
        }
        return null;
    }

    public EnvironmentList setRange(DoubleField.Range range) {
        return this.setRange(range.MIN, range.MAX);
    }

    public EnvironmentList setRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public boolean isEmpty() {
        return this.ENTRIES.length == 0;
    }
}

