/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import fathertoast.crust.api.config.common.value.environment.ComparisonOperator;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeCategory;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeCategoryEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeTagEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.RainfallEnvironment;
import fathertoast.crust.api.config.common.value.environment.biome.TemperatureEnvironment;
import fathertoast.crust.api.config.common.value.environment.compat.ApocalypseDifficultyEnvironment;
import fathertoast.crust.api.config.common.value.environment.compat.ApocalypseDifficultyOrTimeEnvironment;
import fathertoast.crust.api.config.common.value.environment.dimension.DimensionPropertyEnvironment;
import fathertoast.crust.api.config.common.value.environment.dimension.DimensionTypeEnvironment;
import fathertoast.crust.api.config.common.value.environment.dimension.DimensionTypeGroupEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.PositionEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.StructureEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.YEnvironment;
import fathertoast.crust.api.config.common.value.environment.position.YFromSeaEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.ChunkTimeEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.DayTimeEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.MoonBrightnessEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.MoonPhaseEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.SpecialDifficultyEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.TimeFromMidnightEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.WeatherEnvironment;
import fathertoast.crust.api.config.common.value.environment.time.WorldTimeEnvironment;
import fathertoast.crust.api.lib.EnvironmentHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.Tags;

public class EnvironmentEntry {
    public final double VALUE;
    private final AbstractEnvironment[] CONDITIONS;

    public EnvironmentEntry(double value, List<AbstractEnvironment> conditions) {
        this(value, conditions.toArray(new AbstractEnvironment[0]));
    }

    public EnvironmentEntry(double value, AbstractEnvironment ... conditions) {
        this.VALUE = value;
        this.CONDITIONS = conditions;
    }

    public boolean matches(Level world, BlockPos pos) {
        if (!EnvironmentHelper.isLoaded((LevelAccessor)world, pos)) {
            throw new IllegalStateException("Attempted to query world data in an unloaded chunk. This is bad!");
        }
        return this.unsafeMatches(world, pos);
    }

    public boolean matches(Level world) {
        return this.unsafeMatches(world, null);
    }

    boolean unsafeMatches(Level world, @Nullable BlockPos pos) {
        for (AbstractEnvironment condition : this.CONDITIONS) {
            if (condition.matches(world, pos)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder str = new StringBuilder().append(this.VALUE);
        if (this.CONDITIONS.length > 0) {
            str.append(' ');
            boolean first = true;
            for (AbstractEnvironment condition : this.CONDITIONS) {
                if (first) {
                    first = false;
                } else {
                    str.append(" & ");
                }
                str.append(condition);
            }
        }
        return str.toString();
    }

    public static Builder builder(CrustConfigSpec spec, float value) {
        return EnvironmentEntry.builder(spec.MANAGER, value);
    }

    public static Builder builder(ConfigManager cfgManager, float value) {
        return new Builder(cfgManager, (double)Math.round((double)value * 100.0) / 100.0);
    }

    public static Builder builder(CrustConfigSpec spec, double value) {
        return EnvironmentEntry.builder(spec.MANAGER, value);
    }

    public static Builder builder(ConfigManager cfgManager, double value) {
        return new Builder(cfgManager, value);
    }

    public static class Builder {
        private final ConfigManager MANAGER;
        private final double VALUE;
        private final ArrayList<AbstractEnvironment> CONDITIONS = new ArrayList();

        private Builder(ConfigManager cfgManager, double value) {
            this.MANAGER = cfgManager;
            this.VALUE = value;
        }

        public EnvironmentEntry build() {
            return new EnvironmentEntry(this.VALUE, this.CONDITIONS);
        }

        public Builder in(AbstractEnvironment condition) {
            this.CONDITIONS.add(condition);
            return this;
        }

        public Builder inUltraWarmDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.ULTRAWARM, false);
        }

        public Builder notInUltraWarmDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.ULTRAWARM, true);
        }

        public Builder inNaturalDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.NATURAL, false);
        }

        public Builder notInNaturalDimension() {
            return this.inDimensionWithProperty(DimensionPropertyEnvironment.Value.NATURAL, true);
        }

        private Builder inDimensionWithProperty(DimensionPropertyEnvironment.Value property, boolean invert) {
            return this.in(new DimensionPropertyEnvironment(property, invert));
        }

        public Builder inOverworld() {
            return this.inDimensionType((ResourceKey<Level>)Level.f_46428_, false);
        }

        public Builder notInOverworld() {
            return this.inDimensionType((ResourceKey<Level>)Level.f_46428_, true);
        }

        public Builder inNether() {
            return this.inDimensionType((ResourceKey<Level>)Level.f_46429_, false);
        }

        public Builder notInNether() {
            return this.inDimensionType((ResourceKey<Level>)Level.f_46429_, true);
        }

        public Builder inTheEnd() {
            return this.inDimensionType((ResourceKey<Level>)Level.f_46430_, false);
        }

        public Builder notInTheEnd() {
            return this.inDimensionType((ResourceKey<Level>)Level.f_46430_, true);
        }

        private Builder inDimensionType(ResourceKey<Level> dimType, boolean invert) {
            return this.in(new DimensionTypeEnvironment(this.MANAGER, dimType, invert));
        }

        public Builder inVanillaDimension() {
            return this.in(new DimensionTypeGroupEnvironment(this.MANAGER, ResourceLocation.parse((String)""), false));
        }

        public Builder notInVanillaDimension() {
            return this.in(new DimensionTypeGroupEnvironment(this.MANAGER, ResourceLocation.parse((String)""), true));
        }

        public Builder inDryBiome() {
            return this.inAvgRainfall(ComparisonOperator.EQUAL_TO, 0.0f);
        }

        public Builder notInDryBiome() {
            return this.inAvgRainfall(ComparisonOperator.EQUAL_TO.invert(), 0.0f);
        }

        public Builder inHumidBiome() {
            return this.inAvgRainfall(ComparisonOperator.GREATER_THAN, 0.85f);
        }

        public Builder notInHumidBiome() {
            return this.inAvgRainfall(ComparisonOperator.GREATER_THAN.invert(), 0.85f);
        }

        private Builder inAvgRainfall(ComparisonOperator op, float value) {
            return this.in(new RainfallEnvironment(op, value));
        }

        public Builder isFreezing() {
            return this.in(new TemperatureEnvironment(true));
        }

        public Builder isNotFreezing() {
            return this.in(new TemperatureEnvironment(false));
        }

        public Builder isWarm() {
            return this.isTemperature(ComparisonOperator.GREATER_OR_EQUAL, 0.8f);
        }

        public Builder isNotWarm() {
            return this.isTemperature(ComparisonOperator.GREATER_OR_EQUAL.invert(), 0.8f);
        }

        public Builder isHot() {
            return this.isTemperature(ComparisonOperator.GREATER_THAN, 1.0f);
        }

        public Builder isNotHot() {
            return this.isTemperature(ComparisonOperator.GREATER_THAN.invert(), 1.0f);
        }

        private Builder isTemperature(ComparisonOperator op, float value) {
            return this.in(new TemperatureEnvironment(op, value));
        }

        public Builder inWaterBiome() {
            return this.inBiome((TagKey<Biome>)Tags.Biomes.IS_WATER);
        }

        public Builder notInWaterBiome() {
            return this.notInBiome((TagKey<Biome>)Tags.Biomes.IS_WATER);
        }

        public Builder inMountainBiome() {
            return this.inBiome((TagKey<Biome>)Tags.Biomes.IS_MOUNTAIN);
        }

        public Builder notInMountainBiome() {
            return this.notInBiome((TagKey<Biome>)Tags.Biomes.IS_MOUNTAIN);
        }

        public Builder inFlatBiome() {
            return this.inBiome((TagKey<Biome>)Tags.Biomes.IS_PLAINS);
        }

        public Builder notInFlatBiome() {
            return this.notInBiome((TagKey<Biome>)Tags.Biomes.IS_PLAINS);
        }

        @Deprecated(forRemoval=true)
        public Builder inHillyBiome() {
            return this.inBiome((TagKey<Biome>)Tags.Biomes.IS_SLOPE);
        }

        @Deprecated(forRemoval=true)
        public Builder notInHillyBiome() {
            return this.notInBiome((TagKey<Biome>)Tags.Biomes.IS_SLOPE);
        }

        public Builder inSpookyBiome() {
            return this.inBiome((TagKey<Biome>)Tags.Biomes.IS_SPOOKY);
        }

        public Builder notInSpookyBiome() {
            return this.notInBiome((TagKey<Biome>)Tags.Biomes.IS_SPOOKY);
        }

        public Builder inRareBiome() {
            return this.inBiome((TagKey<Biome>)Tags.Biomes.IS_RARE);
        }

        public Builder notInRareBiome() {
            return this.notInBiome((TagKey<Biome>)Tags.Biomes.IS_RARE);
        }

        public Builder inBiome(TagKey<Biome> biome) {
            return this.in(new BiomeTagEnvironment(biome, false));
        }

        public Builder notInBiome(TagKey<Biome> biome) {
            return this.in(new BiomeTagEnvironment(biome, true));
        }

        public Builder inBiome(ResourceKey<Biome> biome) {
            return this.in(new BiomeEnvironment(this.MANAGER, biome, false));
        }

        public Builder notInBiome(ResourceKey<Biome> biome) {
            return this.in(new BiomeEnvironment(this.MANAGER, biome, true));
        }

        @Deprecated(forRemoval=true)
        public Builder inBiomeCategory(BiomeCategory category) {
            return this.in(new BiomeCategoryEnvironment(category, false));
        }

        @Deprecated(forRemoval=true)
        public Builder notInBiomeCategory(BiomeCategory category) {
            return this.in(new BiomeCategoryEnvironment(category, true));
        }

        public Builder inStructure(ResourceKey<Structure> structure) {
            return this.in(new StructureEnvironment(this.MANAGER, structure, false));
        }

        public Builder notInStructure(ResourceKey<Structure> structure) {
            return this.in(new StructureEnvironment(this.MANAGER, structure, true));
        }

        public Builder belowDiamondLevel() {
            return this.belowY(17);
        }

        public Builder aboveDiamondLevel() {
            return this.aboveY(17);
        }

        public Builder belowGoldLevel() {
            return this.belowY(33);
        }

        public Builder aboveGoldLevel() {
            return this.aboveY(33);
        }

        private Builder belowY(int y) {
            return this.in(new YEnvironment(ComparisonOperator.LESS_THAN, y));
        }

        private Builder aboveY(int y) {
            return this.in(new YEnvironment(ComparisonOperator.LESS_THAN.invert(), y));
        }

        public Builder belowSeaLevel() {
            return this.belowSeaLevel(0);
        }

        public Builder aboveSeaLevel() {
            return this.aboveSeaLevel(0);
        }

        public Builder belowSeaDepths() {
            return this.belowSeaLevel(-17);
        }

        public Builder aboveSeaDepths() {
            return this.aboveSeaLevel(-17);
        }

        public Builder belowSeaFloor() {
            return this.belowSeaLevel(-27);
        }

        public Builder aboveSeaFloor() {
            return this.aboveSeaLevel(-27);
        }

        public Builder belowMountainLevel() {
            return this.belowSeaLevel(25);
        }

        public Builder aboveMountainLevel() {
            return this.aboveSeaLevel(25);
        }

        private Builder belowSeaLevel(int dY) {
            return this.in(new YFromSeaEnvironment(ComparisonOperator.LESS_THAN, dY));
        }

        private Builder aboveSeaLevel(int dY) {
            return this.in(new YFromSeaEnvironment(ComparisonOperator.LESS_THAN.invert(), dY));
        }

        public Builder canSeeSky() {
            return this.inPositionWithState(PositionEnvironment.Value.CAN_SEE_SKY, false);
        }

        public Builder cannotSeeSky() {
            return this.inPositionWithState(PositionEnvironment.Value.CAN_SEE_SKY, true);
        }

        public Builder isNearVillage() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_VILLAGE, false);
        }

        public Builder isNotNearVillage() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_VILLAGE, true);
        }

        public Builder isNearRaid() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_RAID, false);
        }

        public Builder isNotNearRaid() {
            return this.inPositionWithState(PositionEnvironment.Value.IS_NEAR_RAID, true);
        }

        private Builder inPositionWithState(PositionEnvironment.Value state, boolean invert) {
            return this.in(new PositionEnvironment(state, invert));
        }

        public Builder aboveDifficulty(float percent) {
            return this.in(new SpecialDifficultyEnvironment(ComparisonOperator.GREATER_OR_EQUAL, percent));
        }

        public Builder belowDifficulty(float percent) {
            return this.in(new SpecialDifficultyEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), percent));
        }

        public Builder isRaining() {
            return this.inWeather(WeatherEnvironment.Value.RAIN, false);
        }

        public Builder isNotRaining() {
            return this.inWeather(WeatherEnvironment.Value.RAIN, true);
        }

        public Builder isThundering() {
            return this.inWeather(WeatherEnvironment.Value.THUNDER, false);
        }

        public Builder isNotThundering() {
            return this.inWeather(WeatherEnvironment.Value.THUNDER, true);
        }

        private Builder inWeather(WeatherEnvironment.Value weather, boolean invert) {
            return this.in(new WeatherEnvironment(weather, invert));
        }

        public Builder atMaxMoonLight() {
            return this.in(new MoonPhaseEnvironment(MoonPhaseEnvironment.Value.FULL, false));
        }

        public Builder aboveHalfMoonLight() {
            return this.fromHalfMoonLight(ComparisonOperator.GREATER_THAN);
        }

        public Builder atHalfMoonLight() {
            return this.fromHalfMoonLight(ComparisonOperator.EQUAL_TO);
        }

        public Builder belowHalfMoonLight() {
            return this.fromHalfMoonLight(ComparisonOperator.LESS_THAN);
        }

        public Builder atNoMoonLight() {
            return this.in(new MoonPhaseEnvironment(MoonPhaseEnvironment.Value.NEW, false));
        }

        private Builder fromHalfMoonLight(ComparisonOperator op) {
            return this.in(new MoonBrightnessEnvironment(op, 0.5f));
        }

        public Builder isNight() {
            return this.in(new DayTimeEnvironment(DayTimeEnvironment.Value.NIGHT, false));
        }

        public Builder isDay() {
            return this.in(new DayTimeEnvironment(DayTimeEnvironment.Value.DAY, false));
        }

        public Builder isNearMidnight() {
            return this.in(new TimeFromMidnightEnvironment(ComparisonOperator.LESS_OR_EQUAL, 1500));
        }

        public Builder isNotNearMidnight() {
            return this.in(new TimeFromMidnightEnvironment(ComparisonOperator.LESS_OR_EQUAL.invert(), 1500));
        }

        public Builder afterDays(int days) {
            return this.in(new WorldTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL, 24000L * (long)days));
        }

        public Builder beforeDays(int days) {
            return this.in(new WorldTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), 24000L * (long)days));
        }

        public Builder afterMonths(int months) {
            return this.afterDays(months * 8);
        }

        public Builder beforeMonths(int months) {
            return this.beforeDays(months * 8);
        }

        public Builder afterDaysInChunk(int days) {
            return this.in(new ChunkTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL, 24000L * (long)days));
        }

        public Builder beforeDaysInChunk(int days) {
            return this.in(new ChunkTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), 24000L * (long)days));
        }

        public Builder afterDaysOrApocalypseDifficulty(int days) {
            return this.in(new ApocalypseDifficultyOrTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL, 24000L * (long)days));
        }

        public Builder beforeDaysOrApocalypseDifficulty(int days) {
            return this.in(new ApocalypseDifficultyOrTimeEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), 24000L * (long)days));
        }

        public Builder afterMonthsOrApocalypseDifficulty(int months) {
            return this.afterDaysOrApocalypseDifficulty(months * 8);
        }

        public Builder beforeMonthsOrApocalypseDifficulty(int months) {
            return this.beforeDaysOrApocalypseDifficulty(months * 8);
        }

        public Builder aboveApocalypseDifficulty(int days) {
            return this.in(new ApocalypseDifficultyEnvironment(ComparisonOperator.GREATER_OR_EQUAL, 24000L * (long)days));
        }

        public Builder belowApocalypseDifficulty(int days) {
            return this.in(new ApocalypseDifficultyEnvironment(ComparisonOperator.GREATER_OR_EQUAL.invert(), 24000L * (long)days));
        }
    }
}

