/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

public enum CrustAnchor {
    CENTER,
    SCREEN_LEFT,
    LEFT,
    SCREEN_RIGHT,
    RIGHT,
    SCREEN_TOP,
    TOP,
    SCREEN_BOTTOM,
    BOTTOM;

    public static final CrustAnchor[] VERTICAL;
    public static final CrustAnchor[] HORIZONTAL;
    public static final CrustAnchor[] VERTICAL_GUI;
    public static final CrustAnchor[] HORIZONTAL_GUI;

    public int pos(int regionSize, int size) {
        return switch (this) {
            case TOP, LEFT, SCREEN_TOP, SCREEN_LEFT -> 0;
            case BOTTOM, RIGHT, SCREEN_BOTTOM, SCREEN_RIGHT -> regionSize - size;
            default -> (regionSize - size) / 2;
        };
    }

    public int pos(int screenSize, int guiSize, int size) {
        return switch (this) {
            case SCREEN_TOP, SCREEN_LEFT -> 0;
            case SCREEN_BOTTOM, SCREEN_RIGHT -> screenSize - size;
            case TOP, LEFT -> (screenSize - guiSize) / 2 - size;
            case BOTTOM, RIGHT -> (screenSize + guiSize) / 2;
            default -> (screenSize - size) / 2;
        };
    }

    public int pos(int screenSize, int guiSize, int guiPos, int size) {
        return switch (this) {
            case SCREEN_TOP, SCREEN_LEFT -> 0;
            case SCREEN_BOTTOM, SCREEN_RIGHT -> screenSize - size;
            case TOP, LEFT -> guiPos - size;
            case BOTTOM, RIGHT -> guiPos + guiSize;
            default -> guiPos + (guiSize - size) / 2;
        };
    }

    static {
        VERTICAL = new CrustAnchor[]{TOP, CENTER, BOTTOM};
        HORIZONTAL = new CrustAnchor[]{LEFT, CENTER, RIGHT};
        VERTICAL_GUI = new CrustAnchor[]{SCREEN_TOP, TOP, CENTER, BOTTOM, SCREEN_BOTTOM};
        HORIZONTAL_GUI = new CrustAnchor[]{SCREEN_LEFT, LEFT, CENTER, RIGHT, SCREEN_RIGHT};
    }
}

