/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.AttributeEntry;
import fathertoast.crust.api.config.common.value.IStringArray;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;

public class AttributeList
implements IStringArray {
    private final AttributeEntry[] ENTRIES;

    public AttributeList(List<AttributeEntry> entries) {
        this(entries.toArray(new AttributeEntry[0]));
    }

    public AttributeList(AttributeEntry ... entries) {
        this.ENTRIES = entries;
    }

    public String toString() {
        return TomlHelper.toLiteral(this.toStringList().toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof AttributeList)) {
            return false;
        }
        return this.toStringList().equals(((AttributeList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.ENTRIES.length);
        for (AttributeEntry entry : this.ENTRIES) {
            list.add(entry.toString());
        }
        return list;
    }

    public void apply(AttributeSupplier.Builder builder) {
        for (AttributeEntry entry : this.ENTRIES) {
            entry.apply(builder);
        }
    }

    public void apply(LivingEntity entity) {
        for (AttributeEntry entry : this.ENTRIES) {
            entry.apply(entity);
        }
    }
}

