/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.registries.ForgeRegistries;

public class AttributeEntry {
    private final AbstractConfigField FIELD;
    public final ResourceLocation ATTRIBUTE_KEY;
    public final boolean MULTIPLY;
    public final double VALUE;
    private Attribute attribute;

    public static AttributeEntry add(Attribute attribute, double value) {
        if (attribute.equals(Attributes.f_22279_)) {
            throw new IllegalArgumentException("Move speed should not be added!");
        }
        return new AttributeEntry(attribute, false, value);
    }

    public static AttributeEntry mult(Attribute attribute, double value) {
        return new AttributeEntry(attribute, true, value);
    }

    private AttributeEntry(Attribute attrib, boolean multiply, double value) {
        this(null, ForgeRegistries.ATTRIBUTES.getKey((Object)attrib), multiply, value);
        this.attribute = attrib;
    }

    public AttributeEntry(@Nullable AbstractConfigField field, @Nullable ResourceLocation regKey, boolean multiply, double value) {
        this.FIELD = field;
        this.ATTRIBUTE_KEY = regKey;
        this.MULTIPLY = multiply;
        this.VALUE = value;
    }

    private boolean validate() {
        if (this.attribute != null) {
            return true;
        }
        if (!ForgeRegistries.ATTRIBUTES.containsKey(this.ATTRIBUTE_KEY)) {
            ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.ATTRIBUTE_KEY.toString());
            return false;
        }
        this.attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(this.ATTRIBUTE_KEY);
        return true;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.ATTRIBUTE_KEY.toString()).append(' ');
        if (this.MULTIPLY) {
            str.append("* ").append(this.VALUE);
        } else if (this.VALUE < 0.0) {
            str.append("- ").append(-this.VALUE);
        } else {
            str.append("+ ").append(this.VALUE);
        }
        return str.toString();
    }

    public void apply(AttributeSupplier.Builder builder) {
        if (this.validate()) {
            this.apply((AttributeInstance)builder.f_22262_.get(this.attribute));
        }
    }

    public void apply(LivingEntity entity) {
        if (this.validate()) {
            this.apply(entity.m_21051_(this.attribute));
        }
    }

    private void apply(@Nullable AttributeInstance attributeInstance) {
        if (attributeInstance == null) {
            throw new IllegalStateException("Attempted to modify non-registered attribute " + this.ATTRIBUTE_KEY);
        }
        if (this.MULTIPLY) {
            attributeInstance.m_22100_(attributeInstance.m_22115_() * this.VALUE);
        } else {
            attributeInstance.m_22100_(attributeInstance.m_22115_() + this.VALUE);
        }
    }
}

