/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.file;

import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.utils.StringUtils;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.value.IStringArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TomlHelper {
    public static int HEX_MODE = 0;

    public static List<String> parseStringList(Object value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value instanceof List) {
            for (Object entry : (List)value) {
                if (entry == null) continue;
                list.add(entry.toString());
            }
        } else {
            list.add(TomlHelper.toLiteral(value));
        }
        return list;
    }

    @Nullable
    public static Integer parseHexInt(@Nullable String value) {
        if (value != null) {
            try {
                return Integer.parseUnsignedInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String enumToString(Enum<?> value) {
        return value.name().toLowerCase();
    }

    @Nullable
    public static Number asNumber(@Nullable Object raw) {
        return raw instanceof Number ? (Number)((Number)raw) : (Number)null;
    }

    @Nullable
    public static Number parseNumber(@Nullable String value) {
        return TomlHelper.asNumber(TomlHelper.parseStringPrimitive(value));
    }

    @Nullable
    public static Boolean asBoolean(@Nullable Object raw) {
        return raw instanceof Boolean ? (Boolean)raw : null;
    }

    @Nullable
    public static Boolean parseBoolean(@Nullable String value) {
        return TomlHelper.asBoolean(TomlHelper.parseStringPrimitive(value));
    }

    public static Object parseStringPrimitive(@Nullable String value) {
        block6: {
            if (value != null && !"".equals(value)) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException ex) {
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (Boolean.TRUE.toString().equalsIgnoreCase(value)) {
                            return Boolean.TRUE;
                        }
                        if (!Boolean.FALSE.toString().equalsIgnoreCase(value)) break block6;
                        return Boolean.FALSE;
                    }
                }
            }
        }
        return NullObject.NULL_OBJECT;
    }

    public static boolean equals(@Nullable Object valueA, @Nullable Object valueB) {
        return Objects.equals(TomlHelper.toLiteral(valueA), TomlHelper.toLiteral(valueB));
    }

    public static String toLiteralForComment(@Nullable Object value) {
        List<String> list;
        if (value instanceof IStringArray && (list = ((IStringArray)value).toStringList()).size() > 10) {
            String str = TomlHelper.toLiteral(list.subList(0, 9).toArray());
            return str.substring(0, str.length() - 2) + ", ... ]";
        }
        return TomlHelper.toLiteral(value);
    }

    public static String toLiteral(@Nullable Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof List) {
            return TomlHelper.toLiteral(((List)value).toArray());
        }
        if (value instanceof Enum) {
            return "\"" + TomlHelper.enumToString((Enum)value) + "\"";
        }
        if (value instanceof String) {
            return "\"" + ((String)value).replace("\"", "\\\"") + "\"";
        }
        if (HEX_MODE > 0 && value instanceof Integer) {
            Object hex = Integer.toHexString((Integer)value).toUpperCase(Locale.ROOT);
            if (HEX_MODE > ((String)hex).length()) {
                StringBuilder padding = new StringBuilder();
                int i = HEX_MODE - ((String)hex).length();
                while (i-- > 0) {
                    padding.append('0');
                }
                hex = padding + (String)hex;
            }
            return "0x" + (String)hex;
        }
        return value.toString();
    }

    public static String toLiteral(Object ... values) {
        if (values == null) {
            return "";
        }
        if (values.length < 1) {
            return "[]";
        }
        return "[ " + TomlHelper.toLiteralList(values) + " ]";
    }

    public static String toLiteralList(Object ... list) {
        return TomlHelper.literalList(Arrays.asList(list));
    }

    public static String literalList(@Nullable List<?> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder literals = new StringBuilder();
        for (Object obj : list) {
            literals.append(TomlHelper.toLiteral(obj)).append(", ");
        }
        literals.delete(literals.length() - 2, literals.length());
        return literals.toString();
    }

    public static String fieldInfoNoHelp(String typeName, Object defaultValue) {
        return String.format("<%s> Default: %s", typeName, TomlHelper.toLiteralForComment(defaultValue));
    }

    public static String fieldInfoFormat(String typeName, Object defaultValue, String format) {
        return String.format("<%s> Format: %s, Default: %s", typeName, format, TomlHelper.toLiteralForComment(defaultValue));
    }

    public static String fieldInfoValidValues(String typeName, Object defaultValue, Object ... validValues) {
        return String.format("<%s> Valid Values: { %s }, Default: %s", typeName, TomlHelper.toLiteralList(validValues), TomlHelper.toLiteralForComment(defaultValue));
    }

    public static String multiFieldInfo(IntField.Range range) {
        return TomlHelper.multiFieldInfo(range.MIN, range.MAX);
    }

    public static String multiFieldInfo(int min, int max) {
        return String.format("<%s> Range: %s", "Integer", TomlHelper.fieldRange(min, max));
    }

    public static String multiFieldInfo(DoubleField.Range range) {
        return TomlHelper.multiFieldInfo(range.MIN, range.MAX);
    }

    public static String multiFieldInfo(double min, double max) {
        return String.format("<%s> Range: %s", "Number", TomlHelper.fieldRange(min, max));
    }

    public static String fieldInfoRange(int defaultValue, int min, int max) {
        return TomlHelper.fieldInfoRange("Integer", TomlHelper.fieldRange(min, max), (Number)defaultValue);
    }

    public static String fieldInfoRange(double defaultValue, double min, double max) {
        return TomlHelper.fieldInfoRange("Number", TomlHelper.fieldRange(min, max), (Number)defaultValue);
    }

    private static String fieldInfoRange(String typeName, String range, Number defaultValue) {
        return String.format("<%s> Range: %s, Default: %s", typeName, range, TomlHelper.toLiteral((Object)defaultValue));
    }

    public static String fieldRange(int min, int max) {
        if (min == Integer.MIN_VALUE) {
            if (max == Integer.MAX_VALUE) {
                return TomlHelper.fieldRangeNoLimit();
            }
            return TomlHelper.fieldRangeUpperLimit(max);
        }
        if (max == Integer.MAX_VALUE) {
            return TomlHelper.fieldRangeLowerLimit(min);
        }
        return TomlHelper.fieldRangeInterval(min, max);
    }

    public static String fieldRange(double min, double max) {
        if (min <= -1.7976931348623157E308) {
            if (max >= Double.MAX_VALUE) {
                return TomlHelper.fieldRangeNoLimit();
            }
            return TomlHelper.fieldRangeUpperLimit(max);
        }
        if (max >= Double.MAX_VALUE) {
            return TomlHelper.fieldRangeLowerLimit(min);
        }
        return TomlHelper.fieldRangeInterval(min, max);
    }

    private static String fieldRangeNoLimit() {
        return "Any Value";
    }

    private static String fieldRangeUpperLimit(Number max) {
        return "\u2264 " + TomlHelper.toLiteral((Object)max);
    }

    private static String fieldRangeLowerLimit(Number min) {
        return "\u2265 " + TomlHelper.toLiteral((Object)min);
    }

    private static String fieldRangeInterval(Number min, Number max) {
        return TomlHelper.toLiteral((Object)min) + " ~ " + TomlHelper.toLiteral((Object)max);
    }

    public static List<String> splitKey(String key) {
        return StringUtils.split((String)key, (char)'.');
    }

    public static String mergePath(@Nullable List<String> path) {
        if (path == null || path.isEmpty()) {
            return "";
        }
        StringBuilder key = new StringBuilder();
        for (String subKey : path) {
            key.append(subKey).append('.');
        }
        key.deleteCharAt(key.length() - 1);
        return key.toString();
    }

    public static ArrayList<String> newComment(String ... lines) {
        return new ArrayList<String>(Arrays.asList(lines));
    }

    public static String combineList(Object ... list) {
        return TomlHelper.combineList(Arrays.asList(list));
    }

    public static String combineList(@Nullable List<Object> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder key = new StringBuilder();
        for (Object obj : list) {
            key.append(obj).append(", ");
        }
        key.delete(key.length() - 2, key.length());
        return key.toString();
    }
}

