/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.file;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.core.io.IndentStyle;
import com.electronwill.nightconfig.core.io.NewlineStyle;
import com.electronwill.nightconfig.core.io.WriterOutput;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.RestartNote;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import java.io.Writer;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.util.StringUtil;

public class CrustTomlWriter
implements ConfigWriter {
    private static final int WRAP_LENGTH = 120;
    private static final char[] CHARS_INDENT = IndentStyle.SPACES_2.chars;
    private static final char[] CHARS_NEW_LINE = NewlineStyle.system().chars;
    private static final char[] CHARS_COMMENT = new char[]{'#', ' '};
    private static final char[] CHARS_ASSIGN = new char[]{' ', '=', ' '};
    private int currentIndentLevel;
    private boolean skipNextIndent;
    private final CrustConfigSpec CONFIG_SPEC;

    CrustTomlWriter(CrustConfigSpec spec) {
        this.CONFIG_SPEC = spec;
    }

    public void write(UnmodifiableConfig config, Writer writer) {
        this.CONFIG_SPEC.writing = true;
        ConfigUtil.LOG.debug("Writing config file! ({}{})", (Object)this.CONFIG_SPEC.NAME, (Object)".toml");
        WriterOutput output = new WriterOutput(writer);
        this.currentIndentLevel = 0;
        this.CONFIG_SPEC.write(this, (CharacterOutput)output);
        this.CONFIG_SPEC.writing = false;
    }

    public void increaseIndentLevel() {
        this.changeIndentLevel(1);
    }

    public void decreaseIndentLevel() {
        this.changeIndentLevel(-1);
    }

    public void changeIndentLevel(int amount) {
        this.currentIndentLevel = Math.max(0, this.currentIndentLevel + amount);
    }

    private void writeIndent(CharacterOutput output) {
        if (this.skipNextIndent) {
            this.skipNextIndent = false;
        } else {
            for (int i = 0; i < this.currentIndentLevel; ++i) {
                output.write(CHARS_INDENT);
            }
        }
    }

    public void continueLine() {
        this.skipNextIndent = true;
    }

    public void writeNewLine(CharacterOutput output) {
        output.write(CHARS_NEW_LINE);
    }

    public void writeLine(String line, CharacterOutput output) {
        this.writeIndent(output);
        output.write(line);
        this.writeNewLine(output);
    }

    public void writeStringArray(@Nullable List<String> list, CharacterOutput output) {
        if (list == null || list.isEmpty()) {
            this.writeLine("[]", output);
            return;
        }
        this.writeLine("[", output);
        this.increaseIndentLevel();
        ListIterator<String> itr = list.listIterator();
        while (itr.hasNext()) {
            this.writeIndent(output);
            output.write(String.format("\"%s\"", itr.next()));
            if (itr.hasNext()) {
                output.write(',');
            }
            this.writeNewLine(output);
        }
        this.decreaseIndentLevel();
        this.writeLine("]", output);
    }

    public void writeComment(List<String> comment, CharacterOutput output) {
        for (String line : comment) {
            this.writeComment(line, output);
        }
    }

    public void writeComment(String comment, CharacterOutput output) {
        for (String line : ConfigUtil.wrap(StringUtil.m_14406_((String)comment), this.getEffectiveWrapLength())) {
            this.writeCommentLine(line, output);
        }
    }

    private int getEffectiveWrapLength() {
        return 120 - CHARS_COMMENT.length - this.currentIndentLevel * CHARS_INDENT.length;
    }

    private void writeCommentLine(String comment, CharacterOutput output) {
        this.writeIndent(output);
        output.write(CHARS_COMMENT);
        output.write(comment);
        this.writeNewLine(output);
    }

    public void writeField(AbstractConfigField field, @Nullable RestartNote restartNote, List<String> addedComment, CharacterOutput output) {
        if (field.getComment() != null) {
            this.writeComment(field.getComment(), output);
            if (restartNote != null) {
                this.writeComment(restartNote.COMMENT, output);
            }
            this.writeComment(addedComment, output);
        }
        this.writeIndent(output);
        output.write(field.getKey());
        output.write(CHARS_ASSIGN);
        this.continueLine();
        field.writeValue(this, output);
    }
}

