/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import com.electronwill.nightconfig.core.io.CharacterOutput;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.CrustTomlWriter;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.List;
import javax.annotation.Nullable;

public class StringListField
extends GenericField<List<String>> {
    protected final String type;

    public StringListField(String key, List<String> defaultValue, String ... description) {
        this(key, "String", defaultValue, description);
    }

    public StringListField(String key, String typeName, List<String> defaultValue, String ... description) {
        super(key, defaultValue, description);
        this.type = typeName;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat(this.type + " List", this.valueDefault, "[ \"" + ConfigUtil.toLowerCaseNoSpaces(this.type) + "1\", \"" + ConfigUtil.toLowerCaseNoSpaces(this.type) + "2\", ... ]"));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        this.value = TomlHelper.parseStringList(raw);
    }

    @Override
    public void writeValue(CrustTomlWriter writer, CharacterOutput output) {
        writer.writeStringArray((List)this.get(), output);
    }

    public boolean isEmpty() {
        return ((List)this.get()).isEmpty();
    }
}

