/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.RegistryEntryList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryEntryListField<T>
extends GenericField<RegistryEntryList<T>> {
    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Registry Entry List fields: General format = [ \"namespace:entry_name\", ... ]");
        comment.add("  Registry entry lists are arrays of registry keys. Many things in the game, such as blocks or potions, are defined by their registry key within a registry. For example, all items are registered in the \"minecraft:item\" registry.");
        comment.add("  An asterisk '*' can be used to match all registry entries/keys belonging to X namespace. For example, 'minecraft:*' will match all vanilla entries.");
        comment.add("  Tags can also be used here. To declare a tag, start with a '#' followed by the rest of the tag path.");
        comment.add("  Tag example: '#minecraft:oak_logs'");
        return comment;
    }

    public RegistryEntryListField(String key, RegistryEntryList<T> defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("\"" + ConfigUtil.toString(((RegistryEntryList)this.valueDefault).getRegistry().getRegistryName()) + "\" Registry List", this.valueDefault, "[ \"namespace:entry_name\", ... ]"));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        if (raw instanceof RegistryEntryList) {
            try {
                this.value = (RegistryEntryList)raw;
            }
            catch (ClassCastException ex) {
                ConfigUtil.LOG.warn("Invalid value for {} \"{}\" (wrong registry)! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
                this.value = this.valueDefault;
            }
        } else {
            this.value = new RegistryEntryList(this, ((RegistryEntryList)this.valueDefault).getRegistry(), TomlHelper.parseStringList(raw));
        }
    }

    public IForgeRegistry<T> getRegistry() {
        return ((RegistryEntryList)this.get()).getRegistry();
    }

    public Set<T> getEntries() {
        return ((RegistryEntryList)this.get()).getEntries();
    }

    public boolean isEmpty() {
        return ((RegistryEntryList)this.get()).isEmpty();
    }

    public boolean contains(@Nullable T entry) {
        return ((RegistryEntryList)this.get()).contains(entry);
    }
}

