/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.StringListField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class PredicateStringListField
extends StringListField {
    private final Predicate<String> lineValidator;

    public PredicateStringListField(String key, String typeName, List<String> defaultValue, Predicate<String> lineValidator, String ... description) {
        super(key, typeName, defaultValue, description);
        Objects.requireNonNull(lineValidator);
        this.lineValidator = lineValidator;
        for (String line : defaultValue) {
            if (lineValidator.test(line)) continue;
            throw new IllegalArgumentException(String.format("Predicate string list has invalid default value! (%s) See: (%s)", line, this.getKey()));
        }
    }

    public PredicateStringListField(String key, List<String> defaultValue, Predicate<String> lineValidator, String ... description) {
        this(key, "String", defaultValue, lineValidator, description);
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        List<String> rawParsed = TomlHelper.parseStringList(raw);
        this.value = this.loadValidated(rawParsed, this.lineValidator);
    }

    protected List<String> loadValidated(List<String> strings, Predicate<String> lineValidator) {
        strings.removeIf(line -> {
            if (lineValidator.test((String)line)) {
                return false;
            }
            ConfigUtil.LOG.warn("Value for {} \"{}\" is invalid! Ignoring value. Invalid value: {}", this.getClass(), (Object)this.getKey(), line);
            return true;
        });
        return strings;
    }
}

