/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.DefaultValueEntry;
import fathertoast.crust.api.config.common.value.EntityEntry;
import fathertoast.crust.api.config.common.value.EntityList;
import fathertoast.crust.api.config.common.value.EntityTagEntry;
import fathertoast.crust.api.config.common.value.NamespaceRegistryEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EntityListField
extends GenericField<EntityList> {
    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Entity List fields: General format = [ \"namespace:entity_type value1 value2 ...\", ... ]");
        comment.add("  Entity lists are arrays of entity types. Some entity lists specify a number of values linked to each entity type.");
        comment.add("  Entity types are defined by their key in the entity registry, usually following the pattern 'namespace:entity_name'.");
        comment.add("  'default' can be used instead of an entity type registry key to provide default values for all entities.");
        comment.add("  List entries by default match any entity type derived from (i.e. based on) their entity type. For example, '~minecraft:zombie'.");
        comment.add("    There is no steadfast rule about extending, even in vanilla, but the hope is that mod-added mobs will extend their base mob.");
        comment.add("  An asterisk '*' can be used to match all registry entries belonging to X namespace. For example, 'minecraft:*' will match all vanilla entries.");
        comment.add("  Entity type tags can also be used here. To declare a tag, start with a '#' followed by the rest of the tag path.");
        comment.add("  Tag example: '#minecraft:beehive_inhabitors'");
        comment.add("      Priority order: specific entries > tag entries > namespace entries > default");
        return comment;
    }

    public EntityListField(String key, EntityList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        String fieldFormat;
        int reqValues = ((EntityList)this.valueDefault).getRequiredValues();
        if (reqValues < 0) {
            fieldFormat = "[ \"namespace:entity_type value1 value2 ...\", ... ]";
        } else {
            StringBuilder format = new StringBuilder("[ \"namespace:entity_type ");
            for (int i = 1; i <= reqValues; ++i) {
                format.append("value");
                if (reqValues > 1) {
                    format.append(i);
                }
                format.append(" ");
            }
            format.deleteCharAt(format.length() - 1).append("\", ... ]");
            fieldFormat = format.toString();
        }
        comment.add(TomlHelper.fieldInfoFormat("Entity List", this.valueDefault, fieldFormat));
        if (reqValues != 0) {
            comment.add("   Range for Values: " + TomlHelper.fieldRange(((EntityList)this.valueDefault).getMinValue(), ((EntityList)this.valueDefault).getMaxValue()));
        }
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        if (raw instanceof EntityList) {
            this.value = (EntityList)raw;
        } else {
            List<String> list = TomlHelper.parseStringList(raw);
            ArrayList<EntityEntry> entryList = new ArrayList<EntityEntry>();
            ArrayList<EntityTagEntry> tagEntries = new ArrayList<EntityTagEntry>();
            ArrayList<NamespaceRegistryEntry> namespaceEntries = new ArrayList<NamespaceRegistryEntry>();
            DefaultValueEntry defaultEntry = null;
            for (String line : list) {
                String[] args = line.split(" ");
                if (defaultEntry == null && args[0].equals("default")) {
                    double[] values = this.parseValues(line, args);
                    defaultEntry = new DefaultValueEntry(values);
                    continue;
                }
                if (args[0].endsWith("*")) {
                    namespaceEntries.add(this.parseNamespaceEntry(line));
                    continue;
                }
                if (line.startsWith("#")) {
                    tagEntries.add(this.parseTagEntry(line));
                    continue;
                }
                entryList.add(this.parseEntry(line));
            }
            this.value = new EntityList(defaultEntry, entryList);
            ((EntityList)this.value).addNamespaceEntries(namespaceEntries);
            ((EntityList)this.value).addTagEntries(tagEntries);
        }
    }

    private EntityEntry parseEntry(String line) {
        boolean extendable;
        String modifiedLine = line;
        if (line.startsWith("~")) {
            modifiedLine = line.substring(1);
            extendable = false;
        } else {
            extendable = true;
        }
        String[] args = modifiedLine.split(" ");
        ResourceLocation regKey = ResourceLocation.parse((String)args[0].trim());
        double[] values = this.parseValues(line, args);
        return new EntityEntry(this, regKey, extendable, values);
    }

    private EntityTagEntry parseTagEntry(String line) {
        String[] args = line.split(" ");
        String tag = args[0].substring(1);
        if (tag.isEmpty()) {
            ConfigUtil.LOG.error("Tried to parse entity tag in EntityList \"{}\", but it was malformed! Expected the format \"#namespace:path\" but got \"{}\"!", (Object)this.getKey(), (Object)line);
            throw new IllegalArgumentException();
        }
        ResourceLocation tagLocation = ResourceLocation.m_135820_((String)tag);
        if (tagLocation == null) {
            ConfigUtil.LOG.error("Tried to parse entity tag in EntityList \"{}\", but it could not be read as a ResourceLocation! Expected the format \"#namespace:path\" but got \"{}\"!", (Object)this.getKey(), (Object)line);
            throw new IllegalArgumentException();
        }
        double[] values = this.parseValues(line, args);
        return new EntityTagEntry(this, new TagKey(Registries.f_256939_, tagLocation), values);
    }

    private NamespaceRegistryEntry parseNamespaceEntry(String line) {
        String[] args = line.split(" ");
        String namespace = args[0].split(":")[0];
        if (namespace == null || namespace.isEmpty()) {
            ConfigUtil.LOG.error("Tried to parse namespace entry in EntityList \"{}\", but it was malformed! Expected the format \"namespace:*\" but got \"{}\"!", (Object)this.getKey(), (Object)line);
            throw new IllegalArgumentException();
        }
        double[] values = this.parseValues(line, args);
        return new NamespaceRegistryEntry(this, namespace, values);
    }

    private double[] parseValues(String line, String[] args) {
        ArrayList<Double> valuesList = new ArrayList<Double>();
        int reqValues = ((EntityList)this.valueDefault).getRequiredValues();
        int actualValues = args.length - 1;
        if (reqValues < 0) {
            if (actualValues < 1) {
                ConfigUtil.LOG.warn("Entry has too few values for {} \"{}\"! Expected at least one value. Replacing missing value with 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
                valuesList.add(0.0);
            } else {
                for (i = 1; i < args.length; ++i) {
                    valuesList.add(this.parseValue(args[i], line));
                }
            }
        } else {
            if (reqValues > actualValues) {
                ConfigUtil.LOG.warn("Entry has too few values for {} \"{}\"! Expected {} values, but detected {}. Replacing missing values with 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)reqValues, (Object)actualValues, (Object)line);
            } else if (reqValues < actualValues) {
                ConfigUtil.LOG.warn("Entry has too many values for {} \"{}\"! Expected {} values, but detected {}. Deleting additional values. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)reqValues, (Object)actualValues, (Object)line);
            }
            for (i = 1; i < reqValues + 1; ++i) {
                if (i < args.length) {
                    valuesList.add(this.parseValue(args[i], line));
                    continue;
                }
                valuesList.add(0.0);
            }
        }
        double[] values = new double[valuesList.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (Double)valuesList.get(i);
        }
        return values;
    }

    private double parseValue(String arg, String line) {
        double value;
        try {
            value = Double.parseDouble(arg);
        }
        catch (NumberFormatException ex) {
            ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
            value = 0.0;
        }
        if (value < ((EntityList)this.valueDefault).getMinValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EntityList)this.valueDefault).getMinValue(), (Object)value);
            value = ((EntityList)this.valueDefault).getMinValue();
        } else if (value > ((EntityList)this.valueDefault).getMaxValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EntityList)this.valueDefault).getMaxValue(), (Object)value);
            value = ((EntityList)this.valueDefault).getMaxValue();
        }
        return value;
    }

    public boolean contains(@Nullable Entity entity) {
        return ((EntityList)this.get()).contains(entity);
    }

    @Nullable
    public double[] getValues(@Nullable Entity entity) {
        return ((EntityList)this.get()).getValues(entity);
    }

    public double getValue(@Nullable Entity entity) {
        return ((EntityList)this.get()).getValue(entity);
    }

    public boolean rollChance(@Nullable LivingEntity entity) {
        return ((EntityList)this.get()).rollChance(entity);
    }

    public static class Combined {
        private final EntityListField WHITELIST;
        private final EntityListField BLACKLIST;

        public Combined(EntityListField whitelist, EntityListField blacklist) {
            this.WHITELIST = whitelist;
            this.BLACKLIST = blacklist;
            if (((EntityList)blacklist.valueDefault).getRequiredValues() != 0) {
                throw new IllegalArgumentException("Blacklists cannot have values! See: " + blacklist.getKey());
            }
        }

        public boolean contains(@Nullable Entity entity) {
            return entity != null && !this.BLACKLIST.contains(entity) && this.WHITELIST.contains(entity);
        }

        @Nullable
        public double[] getValues(@Nullable Entity entity) {
            return entity != null && !this.BLACKLIST.contains(entity) ? this.WHITELIST.getValues(entity) : null;
        }

        public double getValue(@Nullable Entity entity) {
            return entity != null && !this.BLACKLIST.contains(entity) ? this.WHITELIST.getValue(entity) : 0.0;
        }

        public boolean rollChance(@Nullable LivingEntity entity) {
            return entity != null && !this.BLACKLIST.contains((Entity)entity) && this.WHITELIST.rollChance(entity);
        }
    }
}

