/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.client.gui.widget.provider.IConfigFieldWidgetProvider;
import fathertoast.crust.api.config.client.gui.widget.provider.NumberFieldWidgetProvider;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.EnvironmentListField;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;

public class DoubleField
extends AbstractConfigField {
    private final double valueDefault;
    private final double valueMin;
    private final double valueMax;
    private double value;

    public DoubleField(String key, double defaultValue, Range range, String ... description) {
        this(key, defaultValue, range.MIN, range.MAX, description);
    }

    public DoubleField(String key, double defaultValue, double min, double max, String ... description) {
        super(key, description);
        this.valueDefault = defaultValue;
        this.valueMin = min;
        this.valueMax = max;
        if (this.valueMin >= this.valueMax) {
            throw new IllegalArgumentException("Maximum value must be greater than the minimum! Invalid field: " + this.getKey());
        }
        if (this.valueDefault < this.valueMin || this.valueDefault > this.valueMax) {
            throw new IllegalArgumentException("Default value is outside of allowed range! Invalid field: " + this.getKey());
        }
    }

    public double get() {
        return this.value;
    }

    public float getFloat() {
        return (float)this.get();
    }

    public boolean rollChance(Random random) {
        return this.rollChance(random.nextDouble());
    }

    public boolean rollChance(RandomSource random) {
        return this.rollChance(random.m_188500_());
    }

    private boolean rollChance(double roll) {
        return roll < this.get();
    }

    public double minValue() {
        return this.valueMin;
    }

    public double maxValue() {
        return this.valueMax;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoRange(this.valueDefault, this.valueMin, this.valueMax));
    }

    @Override
    public void load(@Nullable Object raw) {
        Number newValue;
        if (raw instanceof String) {
            ConfigUtil.LOG.info("Unboxing string value for {} \"{}\" to a different primitive.", this.getClass(), (Object)this.getKey());
            newValue = TomlHelper.parseNumber((String)raw);
        } else {
            newValue = TomlHelper.asNumber(raw);
        }
        if (newValue == null) {
            if (raw != null) {
                ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            }
            this.value = this.valueDefault;
        } else {
            double castValue = newValue.doubleValue();
            if (castValue < this.valueMin) {
                ConfigUtil.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMin, raw);
                this.value = this.valueMin;
            } else if (castValue > this.valueMax) {
                ConfigUtil.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMax, raw);
                this.value = this.valueMax;
            } else {
                this.value = castValue;
            }
        }
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getDefaultValue() {
        return this.valueDefault;
    }

    @Override
    public IConfigFieldWidgetProvider getWidgetProvider() {
        return new NumberFieldWidgetProvider(this, Number::doubleValue, number -> this.valueMin <= number.doubleValue() && number.doubleValue() <= this.valueMax);
    }

    public static enum Range {
        ANY(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY),
        NON_NEGATIVE(0.0, Double.POSITIVE_INFINITY),
        PERCENT(0.0, 1.0),
        SIGNED_PERCENT(-1.0, 1.0),
        DROP_CHANCE(-1.0, 2.0);

        public final double MIN;
        public final double MAX;

        private Range(double min, double max) {
            this.MIN = min;
            this.MAX = max;
        }
    }

    public static class EnvironmentSensitiveWeightedList<T> {
        private final List<Entry<T>> UNDERLYING_LIST;

        public EnvironmentSensitiveWeightedList(T[] values, DoubleField[] baseWeights, EnvironmentListField[] weightExceptions) {
            if (values.length != baseWeights.length || values.length != weightExceptions.length) {
                throw new IllegalArgumentException("All arrays must be equal length!");
            }
            ArrayList<Entry<T>> list = new ArrayList<Entry<T>>();
            for (int i = 0; i < values.length; ++i) {
                list.add(new Entry<T>(values[i], new EnvironmentSensitive(baseWeights[i], weightExceptions[i])));
                if (!(baseWeights[i].valueMin < 0.0) && !(((EnvironmentList)weightExceptions[i].valueDefault).getMinValue() < 0.0)) continue;
                throw new IllegalArgumentException("Weight is not allowed to be negative! See " + baseWeights[i].getKey() + " and/or " + weightExceptions[i].getKey());
            }
            list.trimToSize();
            this.UNDERLYING_LIST = Collections.unmodifiableList(list);
        }

        @Nullable
        public T next(Random random, Level level, @Nullable BlockPos pos) {
            return this.next(random, level, pos, null);
        }

        @Nullable
        public T next(Random random, Level level, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            return this.next(random::nextDouble, level, pos, selector);
        }

        @Nullable
        public T next(RandomSource random, Level level, @Nullable BlockPos pos) {
            return this.next(random, level, pos, null);
        }

        @Nullable
        public T next(RandomSource random, Level level, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            return this.next(() -> ((RandomSource)random).m_188500_(), level, pos, selector);
        }

        @Nullable
        private T next(Supplier<Double> random, Level level, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            double[] weights = new double[this.UNDERLYING_LIST.size()];
            double totalWeight = this.calculateWeights(weights, level, pos, selector);
            return this.next(random, weights, totalWeight);
        }

        @Nullable
        public List<T> next(Random random, int count, Level level, @Nullable BlockPos pos) {
            return this.next(random, count, level, pos, null);
        }

        @Nullable
        public List<T> next(Random random, int count, Level level, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            return this.next(random::nextDouble, count, level, pos, selector);
        }

        @Nullable
        public List<T> next(RandomSource random, int count, Level level, @Nullable BlockPos pos) {
            return this.next(random, count, level, pos, null);
        }

        @Nullable
        public List<T> next(RandomSource random, int count, Level level, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            return this.next(() -> ((RandomSource)random).m_188500_(), count, level, pos, selector);
        }

        @Nullable
        private List<T> next(Supplier<Double> random, int count, Level level, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            double[] weights = new double[this.UNDERLYING_LIST.size()];
            double totalWeight = this.calculateWeights(weights, level, pos, selector);
            if (totalWeight <= 0.0) {
                return null;
            }
            ArrayList<T> items = new ArrayList<T>(count);
            for (int i = 0; i < count; ++i) {
                items.add(this.next(random, weights, totalWeight));
            }
            return items;
        }

        private double calculateWeights(double[] weights, Level level, @Nullable BlockPos pos, @Nullable Predicate<T> selector) {
            double totalWeight = 0.0;
            for (int i = 0; i < weights.length; ++i) {
                Entry<T> entry = this.UNDERLYING_LIST.get(i);
                if (selector != null && !selector.test(entry.VALUE)) continue;
                weights[i] = entry.WEIGHT.get(level, pos);
                totalWeight += weights[i];
            }
            return totalWeight;
        }

        @Nullable
        private T next(Supplier<Double> random, double[] weights, double totalWeight) {
            if (totalWeight <= 0.0) {
                return null;
            }
            double targetWeight = totalWeight * random.get();
            for (int i = 0; i < weights.length; ++i) {
                if (!((targetWeight -= weights[i]) < 0.0)) continue;
                return this.UNDERLYING_LIST.get((int)i).VALUE;
            }
            ConfigUtil.LOG.error("Environment-sensitive weight list was unable to return a value when it should have! This is probably due to error in floating point calculations, perhaps try changing the scale of weights.");
            return null;
        }

        private static class Entry<T> {
            final T VALUE;
            final EnvironmentSensitive WEIGHT;

            Entry(T value, EnvironmentSensitive weight) {
                this.VALUE = value;
                this.WEIGHT = weight;
            }
        }
    }

    public static class EnvironmentSensitive {
        private final DoubleField BASE;
        private final EnvironmentListField EXCEPTIONS;

        public EnvironmentSensitive(DoubleField base, EnvironmentListField exceptions) {
            this.BASE = base;
            this.EXCEPTIONS = exceptions;
        }

        public double get(Level level, @Nullable BlockPos pos) {
            return this.EXCEPTIONS.getOrElse(level, pos, this.BASE);
        }

        public boolean rollChance(RandomSource random, Level level, @Nullable BlockPos pos) {
            return random.m_188500_() < this.get(level, pos);
        }
    }

    public static class RandomRange {
        private final DoubleField MINIMUM;
        private final DoubleField MAXIMUM;

        public RandomRange(CrustConfigSpec spec, String keyBase, double defaultMinValue, double defaultMaxValue, Range range, String ... description) {
            this(spec, keyBase, defaultMinValue, defaultMaxValue, range.MIN, range.MAX, description);
        }

        public RandomRange(CrustConfigSpec spec, String keyBase, double defaultMinValue, double defaultMaxValue, double min, double max, String ... description) {
            this(spec.define(new DoubleField(keyBase + ".min", defaultMinValue, min, max, description)), spec.define(new DoubleField(keyBase + ".max", defaultMaxValue, min, max, new String[0])));
        }

        public RandomRange(DoubleField minimum, DoubleField maximum) {
            this.MINIMUM = minimum;
            this.MAXIMUM = maximum;
            if (minimum.valueDefault > maximum.valueDefault) {
                throw new IllegalArgumentException(String.format("Random range has inverted default values! (%s > %s) See: (%s, %s)", minimum.valueDefault, maximum.valueDefault, minimum.getKey(), maximum.getKey()));
            }
        }

        public double getMin() {
            return this.MINIMUM.get();
        }

        public double getMax() {
            return this.MAXIMUM.get();
        }

        public DoubleField getMinField() {
            return this.MINIMUM;
        }

        public DoubleField getMaxField() {
            return this.MAXIMUM;
        }

        public double next(Random random) {
            return this.next(random::nextDouble);
        }

        public double next(RandomSource random) {
            return this.next(() -> ((RandomSource)random).m_188500_());
        }

        private double next(Supplier<Double> random) {
            double delta = this.getMax() - this.getMin();
            if (delta > 1.0E-4) {
                return this.getMin() + random.get() * delta;
            }
            if (delta < 0.0) {
                ConfigUtil.LOG.warn("Value for range \"({},{})\" is invalid ({} > {})! Ignoring maximum value.", (Object)this.MINIMUM.getKey(), (Object)this.MAXIMUM.getKey(), (Object)this.getMin(), (Object)this.getMax());
            }
            return this.getMin();
        }
    }
}

