/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common;

import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ConfigUtil {
    public static final Logger LOG = LogManager.getLogger((String)"crust/configs");
    public static final String PLUS_OR_MINUS = "\u00b1";
    public static final String LESS_OR_EQUAL = "\u2264";
    public static final String GREATER_OR_EQUAL = "\u2265";

    public static String toLowerCaseNoSpaces(String str) {
        return ConfigUtil.noSpaces(str.toLowerCase(Locale.ROOT));
    }

    public static String noSpaces(String str) {
        return str.replace(' ', '_');
    }

    public static String camelCaseToLowerSpace(String str) {
        StringBuilder spacedStr = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    spacedStr.append(' ');
                }
                spacedStr.append(Character.toLowerCase(c));
                continue;
            }
            spacedStr.append(c);
        }
        return spacedStr.toString();
    }

    public static String camelCaseToLowerUnderscore(String str) {
        return ConfigUtil.noSpaces(ConfigUtil.camelCaseToLowerSpace(str));
    }

    public static String spaceCaseToLowerCamel(String str) {
        return ConfigUtil.underscoreCaseToLowerCamel(ConfigUtil.noSpaces(str));
    }

    public static String underscoreCaseToLowerCamel(String str) {
        StringBuilder camelStr = new StringBuilder();
        boolean upper = false;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '_') {
                upper = true;
                continue;
            }
            if (upper) {
                upper = false;
                camelStr.append(Character.toUpperCase(c));
                continue;
            }
            camelStr.append(Character.toLowerCase(c));
        }
        return camelStr.toString();
    }

    public static String properCase(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String toRelativePath(FileConfig configFile) {
        return ConfigUtil.toRelativePath(configFile.getFile());
    }

    public static String toRelativePath(File gameFile) {
        return FMLPaths.GAMEDIR.get().relativize(gameFile.toPath()).toString();
    }

    public static String toString(@Nullable ResourceKey<?> regKey) {
        return regKey == null ? "null" : ConfigUtil.toString(regKey.m_135782_());
    }

    public static String toString(@Nullable ResourceLocation res) {
        return res == null ? "null" : res.toString();
    }

    public static String toString(@Nullable TagKey<?> tagKey) {
        return tagKey == null ? "null" : "#" + tagKey.f_203868_();
    }

    public static String namespaceWildcard(@Nullable String namespaceWildcard) {
        return namespaceWildcard == null ? "null" : namespaceWildcard + ":*";
    }

    public static List<String> wrap(String str, int length) {
        ArrayList<String> wrappedLines = new ArrayList<String>();
        ConfigUtil.wrap(wrappedLines, str, length);
        return wrappedLines;
    }

    public static void wrap(List<String> wrappedLines, String str, int length) {
        ConfigUtil.wrap(wrappedLines, str, length, "  ", false);
    }

    public static void wrap(List<String> wrappedLines, String str, int length, @Nullable String hangingIndent, boolean hardWrap) {
        int originalLength = str.length();
        if (originalLength <= length) {
            wrappedLines.add(str);
            return;
        }
        int index = 0;
        if (hangingIndent == null) {
            hangingIndent = "";
        } else {
            int indentLength = 0;
            while (Character.isWhitespace(str.charAt(index))) {
                ++indentLength;
                if (++index < originalLength) continue;
            }
            if (indentLength > 0) {
                hangingIndent = str.substring(0, indentLength) + (String)hangingIndent;
            }
            length -= ((String)hangingIndent).length();
        }
        if (length < 2) {
            length = 2;
        }
        boolean hasWrapped = false;
        int lastValidWrapIndex = -1;
        int indexOfLastWrap = index - 1;
        while (index < originalLength) {
            char c = str.charAt(index);
            boolean whitespace = Character.isWhitespace(c);
            if (!whitespace && index - indexOfLastWrap > length) {
                if (lastValidWrapIndex >= 0) {
                    wrappedLines.add(ConfigUtil.extractLine(hasWrapped, str, (String)hangingIndent, indexOfLastWrap, lastValidWrapIndex + 1));
                    indexOfLastWrap = lastValidWrapIndex;
                    hasWrapped = true;
                } else if (hardWrap) {
                    wrappedLines.add(ConfigUtil.extractLine(hasWrapped, str, (String)hangingIndent, indexOfLastWrap, index - 1) + "-");
                    indexOfLastWrap = index - 2;
                    hasWrapped = true;
                }
            }
            if (whitespace || c == '-') {
                lastValidWrapIndex = index;
            }
            ++index;
        }
        wrappedLines.add(ConfigUtil.extractLine(hasWrapped, str, (String)hangingIndent, indexOfLastWrap, originalLength));
    }

    private static String extractLine(boolean hasWrapped, String str, String hangingIndent, int indexOfLastWrap, int wrapToIndex) {
        return hasWrapped ? hangingIndent + str.substring(indexOfLastWrap + 1, wrapToIndex).trim() : str.substring(0, wrapToIndex).replaceFirst("\\s++$", "");
    }
}

