/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common;

import fathertoast.crust.api.config.common.AbstractConfigFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;

public final class ConfigManager {
    public final String MOD_ID;
    public final File DIR;
    public volatile boolean freezeFileWatcher;
    private static final HashMap<String, ConfigManager> MOD_ID_TO_CM_MAP = new HashMap();
    private final List<AbstractConfigFile> configs = new ArrayList<AbstractConfigFile>();
    private byte dynamicRegVersion;

    @Deprecated(forRemoval=true)
    public static ConfigManager create(String path) {
        return ConfigManager.register(new ConfigManager(new File(FMLPaths.CONFIGDIR.get().toFile(), path + "/")));
    }

    public static ConfigManager create(String path, String modId) {
        return ConfigManager.register(new ConfigManager(new File(FMLPaths.CONFIGDIR.get().toFile(), path + "/"), modId));
    }

    @Deprecated(forRemoval=true)
    public static ConfigManager createSimple() {
        return ConfigManager.register(new ConfigManager(FMLPaths.CONFIGDIR.get().toFile()));
    }

    public static ConfigManager createSimple(String modId) {
        return ConfigManager.register(new ConfigManager(FMLPaths.CONFIGDIR.get().toFile(), modId));
    }

    @Nullable
    public static ConfigManager get(String modId) {
        return MOD_ID_TO_CM_MAP.get(modId);
    }

    public static Collection<ConfigManager> getAll() {
        return Collections.unmodifiableCollection(MOD_ID_TO_CM_MAP.values());
    }

    public static ConfigManager getRequired(String modId) {
        ConfigManager cfgManager = ConfigManager.get(modId);
        if (cfgManager == null) {
            throw new IllegalStateException("Required config manager for '" + modId + "' is not present!");
        }
        return cfgManager;
    }

    public List<AbstractConfigFile> getConfigs() {
        return Collections.unmodifiableList(this.configs);
    }

    public byte getDynamicRegVersion() {
        return this.dynamicRegVersion;
    }

    private static ConfigManager register(ConfigManager cfgManager) {
        if (MOD_ID_TO_CM_MAP.containsKey(cfgManager.MOD_ID)) {
            throw new IllegalStateException("Mod '" + cfgManager.MOD_ID + "' cannot have multiple config managers!");
        }
        MOD_ID_TO_CM_MAP.put(cfgManager.MOD_ID, cfgManager);
        return cfgManager;
    }

    @Deprecated(forRemoval=true)
    private ConfigManager(File configDir) {
        this(configDir, ModLoadingContext.get().getActiveNamespace());
    }

    private ConfigManager(File configDir, String modId) {
        Objects.requireNonNull(modId);
        this.MOD_ID = modId;
        this.DIR = configDir;
        if (this.MOD_ID.isEmpty() || this.MOD_ID.equals("minecraft")) {
            throw new IllegalStateException("Attempted to create config manager with invalid modid!");
        }
        MinecraftForge.EVENT_BUS.addListener(this::onResourceReload);
    }

    void register(AbstractConfigFile cfg) {
        this.configs.add(cfg);
    }

    private void onResourceReload(AddReloadListenerEvent event) {
        this.dynamicRegVersion = (byte)(this.dynamicRegVersion + 1);
    }
}

