/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.client.gui.widget.provider;

import fathertoast.crust.api.config.client.gui.widget.CrustConfigFieldList;
import fathertoast.crust.api.config.client.gui.widget.field.PopupListWidget;
import fathertoast.crust.api.config.client.gui.widget.provider.IConfigFieldWidgetProvider;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.EnumField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class EnumFieldWidgetProvider<T extends Enum<T>>
implements IConfigFieldWidgetProvider {
    protected final EnumField<T> FIELD;

    public EnumFieldWidgetProvider(EnumField<T> field) {
        this.FIELD = field;
    }

    @Override
    public void apply(List<AbstractWidget> components, CrustConfigFieldList.FieldEntry listEntry, Object displayValue) {
        Button dropdownButton = new Button(0, 0, 120, 20, this.rawToText(displayValue), button -> this.openDropdownMenu(button, listEntry, this), Supplier::get);
        components.add((AbstractWidget)dropdownButton);
    }

    protected void openDropdownMenu(Button openingButton, CrustConfigFieldList.FieldEntry listEntry, EnumFieldWidgetProvider<T> provider) {
        int y;
        Enum[] validValues = provider.FIELD.validValues();
        int screenHeight = listEntry.PARENT.getHeight();
        int rowHeight = 24;
        int height = validValues.length * rowHeight + 4;
        boolean hasScrollbar = false;
        if (height > screenHeight) {
            y = 0;
            height = screenHeight;
            hasScrollbar = true;
        } else {
            y = openingButton.m_252907_() + height <= screenHeight ? openingButton.m_252907_() : (openingButton.m_252907_() + openingButton.m_93694_() - height >= 0 ? openingButton.m_252907_() + openingButton.m_93694_() - height : (openingButton.m_252907_() + openingButton.m_93694_() / 2 < screenHeight / 2 ? 0 : screenHeight - height));
        }
        PopupListWidget<PopupListWidget.WidgetListEntry> dropdownMenu = new PopupListWidget<PopupListWidget.WidgetListEntry>(openingButton.m_252754_() - 2, y, openingButton.m_5711_() + 4 + (hasScrollbar ? 8 : 0), height, rowHeight, (Component)Component.m_237113_((String)provider.FIELD.getKey()));
        PopupListWidget.WidgetListEntry selectedEntry = null;
        for (Enum value : validValues) {
            boolean isSelected = TomlHelper.equals(value, listEntry.getValue());
            Button selectButton = new Button(0, 0, openingButton.m_5711_(), rowHeight - 4, this.toText(value, (ChatFormatting)(isSelected ? ChatFormatting.GREEN : null)), button -> {
                openingButton.m_93666_(this.toText(value));
                listEntry.updateValue(value);
                listEntry.setPopupWidget(null);
            }, Supplier::get);
            PopupListWidget.WidgetListEntry entry = new PopupListWidget.WidgetListEntry(new AbstractWidget[]{selectButton});
            dropdownMenu.addEntry(entry);
            if (!isSelected) continue;
            selectedEntry = entry;
        }
        if (selectedEntry != null) {
            dropdownMenu.centerScrollOn(selectedEntry);
        }
        listEntry.setPopupWidget(dropdownMenu);
    }

    protected String toReadable(T value) {
        return ConfigUtil.properCase(((Enum)value).name().toLowerCase(Locale.ROOT).replace('_', ' '));
    }

    protected Component toText(T value) {
        return Component.m_237113_((String)this.toReadable(value));
    }

    protected Component toText(T value, @Nullable ChatFormatting format) {
        if (format == null) {
            return this.toText(value);
        }
        return Component.m_237113_((String)this.toReadable(value)).m_130940_(format);
    }

    protected Component rawToText(Object value) {
        try {
            return this.toText((Enum)value);
        }
        catch (ClassCastException classCastException) {
            if (value instanceof String) {
                return Component.m_237113_((String)ConfigUtil.properCase(((String)value).toLowerCase(Locale.ROOT).replace('_', ' ')));
            }
            return Component.m_237119_();
        }
    }
}

