/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.client.gui.widget.field;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import fathertoast.crust.api.config.client.gui.widget.field.IPopupWidget;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;

public class PopupListWidget<E extends AbstractListEntry<E>>
extends AbstractWidget
implements IPopupWidget {
    public static final int DEFAULT_ROW_HEIGHT = 20;
    public static final int ENTRY_PADDING = 4;
    public static final int SCROLLBAR_WIDTH = 6;
    protected final int itemHeight;
    private final List<E> children = new SimpleArrayList();
    private boolean renderSelectionBox = true;
    private boolean renderHeader;
    protected int headerHeight;
    protected int y0;
    protected int y1;
    protected int x0;
    protected int x1;
    private E selected;
    private E dragging;
    private double scrollDistance;
    private boolean scrolling;

    public PopupListWidget(int x, int y, int width, int height, Component message) {
        this(x, y, width, height, 20, message);
    }

    public PopupListWidget(int x, int y, int width, int height, int rowHeight, Component message) {
        super(x, y, width, height, message);
        this.itemHeight = rowHeight;
        this.y0 = y;
        this.y1 = y + height;
        this.x0 = x;
        this.x1 = x + width;
    }

    public void setRenderSelectionBox(boolean visible) {
        this.renderSelectionBox = visible;
    }

    public void setRenderHeader(boolean visible, int height) {
        this.renderHeader = visible;
        this.headerHeight = visible ? height : 0;
    }

    public void addEntry(E entry) {
        this.children.add(entry);
    }

    public final void clearEntries() {
        this.children.clear();
    }

    public void replaceEntries(Collection<E> newEntries) {
        this.clearEntries();
        this.children.addAll(newEntries);
    }

    public void setLeftPos(int x) {
        this.x0 = x;
        this.x1 = x + this.f_93618_;
    }

    @Nullable
    public E remove(int index) {
        AbstractListEntry entry = (AbstractListEntry)this.children.get(index);
        return (E)(this.removeEntry((AbstractListEntry)this.children.get(index)) ? entry : null);
    }

    public boolean removeEntry(E entry) {
        boolean success = this.children.remove(entry);
        if (success && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return success;
    }

    private void bindEntryToSelf(AbstractListEntry<E> entry) {
        entry.parent = this;
    }

    public final List<E> entries() {
        return this.children;
    }

    protected E getEntry(int index) {
        return (E)((AbstractListEntry)this.entries().get(index));
    }

    protected int getItemCount() {
        return this.entries().size();
    }

    public int getLeft() {
        return this.x0;
    }

    public int getRight() {
        return this.x1;
    }

    public int getTop() {
        return this.y0;
    }

    public int getBottom() {
        return this.y1;
    }

    public int getRowLeft() {
        return this.x0 + (this.f_93618_ - this.getRowWidth()) / 2 + 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int index) {
        return this.y0 + 4 - (int)this.getScrollDistance() + index * this.itemHeight + this.headerHeight;
    }

    protected int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    public int getRowWidth() {
        return this.f_93618_;
    }

    protected int getListContentHeight() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected int getScrollHandleHeight() {
        return Mth.m_14045_((int)((int)((float)this.f_93619_ * (float)this.f_93619_ / (float)this.getListContentHeight())), (int)32, (int)(this.f_93619_ - 8));
    }

    protected int getScrollbarLeft() {
        return this.x1 - 2 - 6;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E value) {
        this.selected = value;
    }

    public void setDragging(@Nullable E entry) {
        this.dragging = entry;
    }

    @Nullable
    public E getDragging() {
        return this.dragging;
    }

    protected boolean isSelectedItem(int index) {
        return this.getEntry(index).equals(this.getSelected());
    }

    @Nullable
    protected final E getEntryAtPosition(double x, double y) {
        if (y < (double)this.y0 || y > (double)this.y1 || x >= (double)this.getScrollbarLeft() || x < (double)this.getRowLeft() || x > (double)this.getRowRight()) {
            return null;
        }
        int yFromListTop = Mth.m_14107_((double)(y - (double)this.y0)) - this.headerHeight + (int)this.getScrollDistance() - 4;
        int index = yFromListTop / this.itemHeight;
        return (E)(index >= 0 && index < this.getItemCount() ? (AbstractListEntry)this.entries().get(index) : null);
    }

    public double getScrollDistance() {
        return this.scrollDistance;
    }

    public void setScrollDistance(double value) {
        this.scrollDistance = Mth.m_14008_((double)value, (double)0.0, (double)this.getMaxScrollDistance());
    }

    public void addScrollDistance(int y) {
        this.setScrollDistance(this.getScrollDistance() + (double)y);
    }

    public int getMaxScrollDistance() {
        return Math.max(0, this.getListContentHeight() - (this.f_93619_ - 4));
    }

    public void centerScrollOn(E entry) {
        this.setScrollDistance((double)(this.entries().indexOf(entry) * this.itemHeight) + (double)(this.itemHeight - this.f_93619_) / 2.0);
    }

    public void ensureVisible(E entry) {
        int rowTop = this.getRowTop(this.entries().indexOf(entry));
        int scrollAmount = rowTop - (this.y0 + 4 + this.itemHeight);
        if (scrollAmount < 0) {
            this.addScrollDistance(scrollAmount);
        }
        if ((scrollAmount = rowTop + this.itemHeight - (this.y1 - this.itemHeight)) > 0) {
            this.addScrollDistance(scrollAmount);
        }
    }

    public boolean m_5953_(double x, double y) {
        return y >= (double)this.y0 && y <= (double)this.y1 && x >= (double)this.x0 && x <= (double)this.x1;
    }

    protected void m_168797_(NarrationElementOutput output) {
    }

    public boolean m_6375_(double x, double y, int mouseKey) {
        this.updateScrollingState(x, mouseKey);
        if (!this.m_5953_(x, y)) {
            return false;
        }
        if (this.scrolling) {
            return true;
        }
        E entry = this.getEntryAtPosition(x, y);
        if (entry != null) {
            if (entry.m_6375_(x, y, mouseKey)) {
                this.setDragging(entry);
                return true;
            }
        } else if (mouseKey == 0) {
            this.clickedHeader((int)(x - (double)this.x0) + (this.f_93618_ - this.getRowWidth()) / 2, (int)(y - (double)this.y0) + (int)this.getScrollDistance() - 4);
            return true;
        }
        return false;
    }

    protected void updateScrollingState(double mouseX, int mouseKey) {
        this.scrolling = mouseKey == 0 && mouseX >= (double)this.getScrollbarLeft() && mouseX < (double)(this.getScrollbarLeft() + 6);
    }

    protected void clickedHeader(int headerX, int headerY) {
    }

    public boolean m_6348_(double x, double y, int mouseKey) {
        if (this.getDragging() != null) {
            this.getDragging().m_6348_(x, y, mouseKey);
            this.setDragging(null);
        }
        return false;
    }

    public boolean m_7979_(double x, double y, int mouseKey, double deltaX, double deltaY) {
        if (this.getDragging() != null && mouseKey == 0 && this.getDragging().m_7979_(x, y, mouseKey, deltaX, deltaY)) {
            return true;
        }
        if (mouseKey == 0 && this.scrolling) {
            int maxScroll = this.getMaxScrollDistance();
            if (y < (double)this.y0 || maxScroll <= 0) {
                this.setScrollDistance(0.0);
            } else if (y > (double)this.y1) {
                this.setScrollDistance(maxScroll);
            } else {
                double scrollScale = Math.max(1.0, (double)maxScroll / (double)(this.f_93619_ - this.getScrollHandleHeight()));
                this.setScrollDistance(this.getScrollDistance() + deltaY * scrollScale);
            }
            return true;
        }
        return super.m_7979_(x, y, mouseKey, deltaX, deltaY);
    }

    public boolean m_6050_(double x, double y, double deltaScroll) {
        this.setScrollDistance(this.getScrollDistance() - deltaScroll * (double)this.itemHeight / 2.0);
        return true;
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if (super.m_7933_(key, scancode, mods)) {
            return true;
        }
        if (key == InputConstants.m_84851_((String)"key.keyboard.down").m_84873_()) {
            this.moveSelection(1);
            return true;
        }
        if (key == InputConstants.m_84851_((String)"key.keyboard.up").m_84873_()) {
            this.moveSelection(-1);
            return true;
        }
        return false;
    }

    protected void moveSelection(int dir) {
        this.moveSelection(dir, entry -> true);
    }

    protected void moveSelection(int dir, Predicate<E> filter) {
        if (this.entries().isEmpty()) {
            return;
        }
        for (int i = this.entries().indexOf(this.getSelected()) + dir; i >= 0 && i < this.getItemCount(); i += dir) {
            E entry = this.getEntry(i);
            if (!filter.test(entry)) continue;
            this.setSelected(entry);
            this.ensureVisible(entry);
            break;
        }
    }

    protected void refreshSelection() {
        E entry = this.getSelected();
        if (entry != null) {
            this.setSelected(entry);
            this.ensureVisible(entry);
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buf = tesselator.m_85915_();
        this.renderBackground(graphics, mouseX, mouseY, partialTicks, tesselator, buf);
        this.renderList(graphics, mouseX, mouseY, partialTicks, tesselator, buf);
        if (this.renderHeader) {
            this.renderHeader(graphics, mouseX, mouseY, partialTicks, tesselator, buf);
        }
        this.renderScrollbar(graphics, mouseX, mouseY, partialTicks, tesselator, buf);
        this.renderDecorations(graphics, mouseX, mouseY, partialTicks, tesselator, buf);
        RenderSystem.disableBlend();
    }

    protected void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Tesselator tesselator, BufferBuilder buf) {
        buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        PopupListWidget.drawBox(buf, this.x0, this.x1, this.y0, this.y1, 32);
        tesselator.m_85914_();
    }

    protected void renderList(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Tesselator tesselator, BufferBuilder buf) {
        int rowWidth = this.getRowWidth();
        int rowLeft = this.getRowLeft();
        int rowRight = rowLeft + rowWidth;
        int length = this.getItemCount();
        for (int i = 0; i < length; ++i) {
            int rowTop = this.getRowTop(i);
            int rowBottom = rowTop + this.itemHeight;
            if (rowBottom < this.y0 || rowTop > this.y1) continue;
            if (this.renderSelectionBox && this.isSelectedItem(i)) {
                buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
                PopupListWidget.drawBox(buf, rowLeft, rowRight, rowTop - 2, rowBottom - 4 + 2, this.m_93696_() ? 255 : 127);
                PopupListWidget.drawBox(buf, rowLeft + 1, rowRight - 1, rowTop - 1, rowBottom - 4 + 1, 0);
                tesselator.m_85914_();
            }
            E entry = this.getEntry(i);
            ((AbstractListEntry)entry).render(graphics, i, rowLeft, rowTop, rowWidth, this.itemHeight - 4, mouseX, mouseY, this.m_5953_(mouseX, mouseY) && entry.equals(this.getEntryAtPosition(mouseX, mouseY)), partialTicks);
        }
    }

    protected void renderHeader(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Tesselator tesselator, BufferBuilder buf) {
    }

    protected void renderScrollbar(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Tesselator tesselator, BufferBuilder buf) {
        int maxScroll = this.getMaxScrollDistance();
        if (maxScroll > 0) {
            int scrollX0 = this.getScrollbarLeft();
            int scrollX1 = scrollX0 + 6;
            int handleH = this.getScrollHandleHeight();
            int handleY = this.y0 + (this.f_93619_ - handleH) * (int)this.getScrollDistance() / maxScroll;
            if (handleY < this.y0) {
                handleY = this.y0;
            }
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
            PopupListWidget.drawBox(buf, scrollX0, scrollX1, this.y0, this.y1, 0);
            PopupListWidget.drawBox(buf, scrollX0, scrollX1, handleY, handleY + handleH, 128);
            PopupListWidget.drawBox(buf, scrollX0, scrollX1 - 1, handleY, handleY + handleH - 1, 192);
            tesselator.m_85914_();
        }
    }

    protected void renderDecorations(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, Tesselator tesselator, BufferBuilder buf) {
    }

    protected static void drawBox(BufferBuilder buf, double x0, double x1, double y0, double y1, int b) {
        PopupListWidget.drawBox(buf, x0, x1, y0, y1, 0.0, 0.0f, 1.0f, 0.0f, 1.0f, b, b, b, 255);
    }

    protected static void drawBox(BufferBuilder buf, double x0, double x1, double y0, double y1, int r, int g, int b) {
        PopupListWidget.drawBox(buf, x0, x1, y0, y1, 0.0, 0.0f, 1.0f, 0.0f, 1.0f, r, g, b, 255);
    }

    protected static void drawBox(BufferBuilder buf, double x0, double x1, double y0, double y1, double z, float u0, float u1, float v0, float v1, int r, int g, int b, int a) {
        buf.m_5483_(x0, y1, z).m_7421_(u0, v1).m_6122_(r, g, b, a).m_5752_();
        buf.m_5483_(x1, y1, z).m_7421_(u1, v1).m_6122_(r, g, b, a).m_5752_();
        buf.m_5483_(x1, y0, z).m_7421_(u1, v0).m_6122_(r, g, b, a).m_5752_();
        buf.m_5483_(x0, y0, z).m_7421_(u0, v0).m_6122_(r, g, b, a).m_5752_();
    }

    class SimpleArrayList
    extends AbstractList<E> {
        private final List<E> underlyingList = Lists.newArrayList();

        private SimpleArrayList() {
        }

        @Override
        public E get(int index) {
            return (AbstractListEntry)this.underlyingList.get(index);
        }

        @Override
        public int size() {
            return this.underlyingList.size();
        }

        @Override
        public E set(int index, E element) {
            AbstractListEntry previousElement = (AbstractListEntry)this.underlyingList.set(index, element);
            PopupListWidget.this.bindEntryToSelf(element);
            return previousElement;
        }

        @Override
        public void add(int index, E element) {
            this.underlyingList.add(index, element);
            PopupListWidget.this.bindEntryToSelf(element);
        }

        @Override
        public E remove(int index) {
            return (AbstractListEntry)this.underlyingList.remove(index);
        }
    }

    public static abstract class AbstractListEntry<E extends AbstractListEntry<E>>
    implements GuiEventListener {
        protected PopupListWidget<E> parent;
        private boolean focused;

        public void tick() {
        }

        public abstract void render(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public boolean m_5953_(double mouseX, double mouseY) {
            return this.equals(this.parent.getEntryAtPosition(mouseX, mouseY));
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
        }

        public boolean m_93696_() {
            return this.focused;
        }
    }

    public static class WidgetListEntry
    extends AbstractListEntry<WidgetListEntry> {
        private final AbstractWidget[] WIDGETS;
        private final OffsetWidget[] RENDER_WIDGETS;

        public WidgetListEntry(AbstractWidget ... widgets) {
            this.WIDGETS = widgets;
            this.RENDER_WIDGETS = new OffsetWidget[widgets.length];
            int offset = widgets.length - 1;
            for (int i = 0; i <= offset; ++i) {
                this.RENDER_WIDGETS[offset - i] = new OffsetWidget(this.WIDGETS[i]);
            }
        }

        public WidgetListEntry(Collection<AbstractWidget> widgets) {
            this(widgets.toArray(new AbstractWidget[0]));
        }

        public void m_94757_(double x, double y) {
            for (AbstractWidget w : this.WIDGETS) {
                w.m_94757_(x, y);
            }
        }

        public boolean m_6375_(double x, double y, int mouseKey) {
            for (AbstractWidget w : this.WIDGETS) {
                if (!w.m_6375_(x, y, mouseKey)) continue;
                return true;
            }
            return false;
        }

        public boolean m_6348_(double x, double y, int mouseKey) {
            for (AbstractWidget w : this.WIDGETS) {
                if (!w.m_6348_(x, y, mouseKey)) continue;
                return true;
            }
            return false;
        }

        public boolean m_7979_(double x, double y, int mouseKey, double deltaX, double deltaY) {
            for (AbstractWidget w : this.WIDGETS) {
                if (!w.m_7979_(x, y, mouseKey, deltaX, deltaY)) continue;
                return true;
            }
            return false;
        }

        public boolean m_6050_(double x, double y, double deltaScroll) {
            for (AbstractWidget w : this.WIDGETS) {
                if (!w.m_6050_(x, y, deltaScroll)) continue;
                return true;
            }
            return false;
        }

        public boolean m_7933_(int key, int scancode, int mods) {
            for (AbstractWidget w : this.WIDGETS) {
                if (!w.m_7933_(key, scancode, mods)) continue;
                return true;
            }
            return false;
        }

        public boolean m_7920_(int key, int scancode, int mods) {
            for (AbstractWidget w : this.WIDGETS) {
                if (!w.m_7920_(key, scancode, mods)) continue;
                return true;
            }
            return false;
        }

        public boolean m_5534_(char codePoint, int mods) {
            for (AbstractWidget w : this.WIDGETS) {
                if (!w.m_5534_(codePoint, mods)) continue;
                return true;
            }
            return false;
        }

        public ComponentPath m_264064_(FocusNavigationEvent event) {
            for (AbstractWidget w : this.WIDGETS) {
                ComponentPath path = w.m_264064_(event);
                if (path == null) continue;
                return path;
            }
            return null;
        }

        @Override
        public void render(GuiGraphics graphics, int index, int x, int y, int width, int height, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            for (OffsetWidget off : this.RENDER_WIDGETS) {
                off.WIDGET.m_252865_(x + off.X_OFFSET);
                off.WIDGET.m_253211_(y + off.Y_OFFSET);
                off.WIDGET.m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
        }

        private static class OffsetWidget {
            final AbstractWidget WIDGET;
            final int X_OFFSET;
            final int Y_OFFSET;

            OffsetWidget(AbstractWidget widget) {
                this.WIDGET = widget;
                this.X_OFFSET = widget.m_252754_();
                this.Y_OFFSET = widget.m_252907_();
            }
        }
    }
}

