/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.client.gui.widget;

import com.google.common.collect.ImmutableList;
import fathertoast.crust.api.config.client.gui.screen.CrustConfigFileScreen;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class CrustConfigFileList
extends ContainerObjectSelectionList<Entry> {
    private int maxNameWidth;

    public CrustConfigFileList(Screen parent, Minecraft game, ConfigManager cfgManager) {
        super(game, parent.f_96543_ + 45, parent.f_96544_, 43, parent.f_96544_ - 32, 20);
        Path rootPath = cfgManager.DIR.toPath();
        ArrayList<SortableFile> cfgFiles = new ArrayList<SortableFile>();
        for (AbstractConfigFile cfgFile : cfgManager.getConfigs()) {
            cfgFiles.add(new SortableFile(rootPath, cfgFile));
        }
        Collections.sort(cfgFiles);
        String currentDir = null;
        for (SortableFile cfgFile : cfgFiles) {
            MutableComponent name;
            int nameWidth;
            String dir = cfgFile.DIR;
            if (!dir.equals(currentDir)) {
                currentDir = dir;
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry(this, (Component)Component.m_237113_((String)CrustConfigFileList.makePrettyPath(cfgManager.DIR.getName(), cfgFile.REL_FILE))));
            }
            if ((nameWidth = game.f_91062_.m_92852_((FormattedText)(name = Component.m_237113_((String)CrustConfigFileScreen.getSpecName(cfgFile.SPEC))))) > this.maxNameWidth) {
                this.maxNameWidth = nameWidth;
            }
            this.m_7085_((AbstractSelectionList.Entry)new FileEntry(this, cfgFile.SPEC, (Component)name));
        }
    }

    private static String makePrettyPath(String base, File file) {
        if ((file = file.getParentFile()) == null) {
            return base;
        }
        StringBuilder builder = new StringBuilder();
        do {
            builder.insert(0, file.getName()).insert(0, " > ");
        } while ((file = file.getParentFile()) != null);
        return builder.insert(0, base).toString();
    }

    private static File relativize(Path rootPath, AbstractConfigFile cfgFile) {
        return rootPath.relativize(cfgFile.SPEC.getFile().toPath()).toFile();
    }

    private static class SortableFile
    implements Comparable<SortableFile> {
        final CrustConfigSpec SPEC;
        final File REL_FILE;
        final String DIR;
        final String FILE;

        SortableFile(Path rootPath, AbstractConfigFile cfgFile) {
            this.SPEC = cfgFile.SPEC;
            this.REL_FILE = CrustConfigFileList.relativize(rootPath, cfgFile);
            File file = this.REL_FILE.getParentFile();
            this.DIR = file == null ? "" : file.toString();
            this.FILE = this.REL_FILE.getName();
        }

        @Override
        public int compareTo(SortableFile other) {
            int dirResult = this.DIR.compareTo(other.DIR);
            return dirResult == 0 ? this.FILE.compareTo(other.FILE) : dirResult;
        }
    }

    public static class CategoryEntry
    extends Entry {
        private final CrustConfigFileList PARENT;
        private final Component NAME;
        private final int WIDTH;

        public CategoryEntry(CrustConfigFileList parent, Component name) {
            this.PARENT = parent;
            this.NAME = name;
            this.WIDTH = ((CrustConfigFileList)parent).f_93386_.f_91062_.m_92852_((FormattedText)name);
        }

        public void m_6311_(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            graphics.m_280430_(((CrustConfigFileList)this.PARENT).f_93386_.f_91062_, this.NAME, ((CrustConfigFileList)this.PARENT).f_93386_.f_91080_.f_96543_ - this.WIDTH >> 1, rowTop + rowHeight - 9 - 1, 0xFFFFFF);
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            return null;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }

    public static class FileEntry
    extends Entry {
        private final CrustConfigFileList PARENT;
        private final CrustConfigSpec SPEC;
        private final Component NAME;
        private final Button OPEN_BUTTON;

        private FileEntry(CrustConfigFileList parent, CrustConfigSpec spec, Component name) {
            this.PARENT = parent;
            this.SPEC = spec;
            this.NAME = name;
            this.OPEN_BUTTON = new Button(0, 0, 20, 20, (Component)Component.m_237113_((String)">"), button -> this.PARENT.f_93386_.m_91152_((Screen)new CrustConfigFileScreen(((CrustConfigFileList)this.PARENT).f_93386_.f_91080_, this.SPEC)), Supplier::get);
            if (!this.SPEC.isInitialized()) {
                this.OPEN_BUTTON.f_93623_ = false;
                this.OPEN_BUTTON.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Config failed to load, check logs for details").m_130940_(ChatFormatting.RED)));
            }
        }

        public void m_6311_(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            graphics.m_280430_(((CrustConfigFileList)this.PARENT).f_93386_.f_91062_, this.NAME, ((CrustConfigFileList)this.PARENT).f_93386_.f_91080_.f_96543_ - this.PARENT.maxNameWidth - 30 >> 1, rowTop + (rowHeight - 9 >> 1), 0xFFFFFF);
            this.OPEN_BUTTON.m_252865_((((CrustConfigFileList)this.PARENT).f_93386_.f_91080_.f_96543_ + this.PARENT.maxNameWidth + 30 >> 1) - 20);
            this.OPEN_BUTTON.m_253211_(rowTop);
            this.OPEN_BUTTON.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return ImmutableList.of((Object)this.OPEN_BUTTON);
        }

        public boolean m_6375_(double x, double y, int mouseKey) {
            return this.OPEN_BUTTON.m_6375_(x, y, mouseKey);
        }

        public boolean m_6348_(double x, double y, int mouseKey) {
            return this.OPEN_BUTTON.m_6348_(x, y, mouseKey);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

