/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.client.gui.screen;

import com.mojang.blaze3d.platform.InputConstants;
import fathertoast.crust.api.config.client.gui.screen.CrustConfigSelectScreen;
import fathertoast.crust.api.config.client.gui.widget.CrustConfigFieldList;
import fathertoast.crust.api.config.client.gui.widget.field.IPopupWidget;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

public class CrustConfigFileScreen
extends Screen {
    private final Screen LAST_SCREEN;
    private final CrustConfigSpec SPEC;
    private final Component SUBTITLE;
    private CrustConfigFieldList fieldList;
    private List<FormattedCharSequence> tooltip;
    private Button bottomLeftButton;
    private Button bottomRightButton;
    private EditBox focusedTextBox;
    private AbstractWidget popupWidget;

    public static String getSpecName(CrustConfigSpec spec) {
        String name = spec.getFile().getName();
        return ConfigUtil.properCase(CrustConfigFileScreen.decodeString(name.substring(0, name.length() - ".toml".length())));
    }

    public static String decodeString(String str) {
        return ConfigUtil.camelCaseToLowerSpace(str.replace('_', ' ').replace(".", " > ").trim());
    }

    public CrustConfigFileScreen(Screen parent, CrustConfigSpec spec) {
        super((Component)Component.m_237110_((String)"menu.crust.config.file.title", (Object[])new Object[]{CrustConfigSelectScreen.getModName(spec.MANAGER.MOD_ID), CrustConfigFileScreen.getSpecName(spec)}));
        this.LAST_SCREEN = parent;
        this.SPEC = spec;
        this.SUBTITLE = Component.m_237110_((String)"menu.crust.config.file.subtitle", (Object[])new Object[]{ConfigUtil.toRelativePath(spec.getFile())});
    }

    public void setFocusedTextBox(EditBox textBox) {
        this.focusedTextBox = textBox;
    }

    public void setScrollAmount(double scroll) {
        this.fieldList.m_93410_(scroll);
    }

    public double getScrollAmount() {
        return this.fieldList.m_93517_();
    }

    public void setPopupWidget(@Nullable AbstractWidget popup) {
        this.popupWidget = popup;
    }

    public void setTooltip(@Nullable List<FormattedCharSequence> text) {
        this.tooltip = text;
    }

    public void resetScreen() {
        if (this.f_96541_ != null) {
            CrustConfigFileScreen newScreen = new CrustConfigFileScreen(this.LAST_SCREEN, this.SPEC);
            this.f_96541_.m_91152_((Screen)newScreen);
            newScreen.setScrollAmount(this.getScrollAmount());
        }
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.LAST_SCREEN);
        }
    }

    protected void m_7856_() {
        if (this.f_96541_ == null) {
            return;
        }
        this.fieldList = new CrustConfigFieldList(this, this.f_96541_, this.SPEC);
        this.m_142416_((GuiEventListener)this.fieldList);
        this.bottomLeftButton = new Button(this.f_96543_ / 2 - 155, this.f_96544_ - 29, 150, 20, (Component)Component.m_237115_((String)"menu.crust.config.open_folder"), button -> {
            if (this.fieldList.isChanged()) {
                this.resetScreen();
            } else {
                Util.m_137581_().m_137644_(this.SPEC.getFile().getParentFile());
            }
        }, Supplier::get);
        this.m_142416_((GuiEventListener)this.bottomLeftButton);
        this.bottomRightButton = new Button(this.f_96543_ / 2 - 155 + 160, this.f_96544_ - 29, 150, 20, CommonComponents.f_130655_, button -> {
            if (this.fieldList.isChanged()) {
                this.fieldList.saveChanges();
                this.resetScreen();
            } else {
                this.f_96541_.m_91152_(this.LAST_SCREEN);
            }
        }, Supplier::get);
        this.m_142416_((GuiEventListener)this.bottomRightButton);
    }

    public void updateFooterButtonText() {
        if (this.fieldList.isChanged()) {
            this.bottomLeftButton.m_93666_((Component)Component.m_237115_((String)"menu.crust.config.discard_changes").m_130940_(ChatFormatting.RED));
            this.bottomRightButton.m_93666_((Component)Component.m_237115_((String)"menu.crust.config.save_changes").m_130940_(ChatFormatting.GREEN));
        } else {
            this.bottomLeftButton.m_93666_((Component)Component.m_237115_((String)"menu.crust.config.open_folder"));
            this.bottomRightButton.m_93666_(CommonComponents.f_130655_);
        }
    }

    public void m_94757_(double x, double y) {
        if (this.popupWidget != null) {
            this.popupWidget.m_94757_(x, y);
        } else {
            super.m_94757_(x, y);
        }
    }

    public boolean m_6375_(double x, double y, int mouseKey) {
        if (this.focusedTextBox != null) {
            this.focusedTextBox.m_93692_(false);
            this.focusedTextBox = null;
        }
        if (this.popupWidget != null) {
            if (this.popupWidget.m_5953_(x, y)) {
                this.popupWidget.m_6375_(x, y, mouseKey);
            } else if (this.popupWidget instanceof IPopupWidget) {
                if (((IPopupWidget)this.popupWidget).mouseClickedOutOfBounds(x, y, mouseKey)) {
                    this.popupWidget = null;
                }
            } else {
                this.popupWidget = null;
            }
            return true;
        }
        return super.m_6375_(x, y, mouseKey);
    }

    public boolean m_6348_(double x, double y, int mouseKey) {
        if (this.popupWidget != null) {
            this.popupWidget.m_6348_(x, y, mouseKey);
            return true;
        }
        return super.m_6348_(x, y, mouseKey);
    }

    public boolean m_7979_(double x, double y, int mouseKey, double deltaX, double deltaY) {
        if (this.popupWidget != null) {
            this.popupWidget.m_7979_(x, y, mouseKey, deltaX, deltaY);
            return true;
        }
        return super.m_7979_(x, y, mouseKey, deltaX, deltaY);
    }

    public boolean m_6050_(double x, double y, double deltaScroll) {
        if (this.popupWidget != null) {
            this.popupWidget.m_6050_(x, y, deltaScroll);
            return true;
        }
        return super.m_6050_(x, y, deltaScroll);
    }

    public boolean m_7933_(int key, int scancode, int mods) {
        if (this.popupWidget != null) {
            if (key == InputConstants.m_84851_((String)"key.keyboard.escape").m_84873_() && (!(this.popupWidget instanceof IPopupWidget) || ((IPopupWidget)this.popupWidget).shouldCloseOnEsc())) {
                this.popupWidget = null;
                return true;
            }
            this.popupWidget.m_7933_(key, scancode, mods);
            return true;
        }
        return super.m_7933_(key, scancode, mods);
    }

    public boolean m_7920_(int key, int scancode, int mods) {
        if (this.popupWidget != null) {
            this.popupWidget.m_7920_(key, scancode, mods);
            return true;
        }
        return super.m_7920_(key, scancode, mods);
    }

    public boolean m_5534_(char codePoint, int mods) {
        if (this.popupWidget != null) {
            this.popupWidget.m_5534_(codePoint, mods);
            return true;
        }
        return super.m_5534_(codePoint, mods);
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent event) {
        return super.m_264064_(event);
    }

    public void m_86600_() {
        if (this.focusedTextBox != null) {
            this.focusedTextBox.m_94120_();
        }
        if (this.popupWidget instanceof IPopupWidget) {
            ((IPopupWidget)this.popupWidget).tick();
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.popupWidget == null) {
            this.renderMain(graphics, mouseX, mouseY, partialTicks);
        } else {
            this.renderMain(graphics, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            this.renderPopup(graphics, this.popupWidget, mouseX, mouseY, partialTicks);
        }
        if (this.tooltip != null) {
            graphics.m_280245_(this.f_96547_, this.tooltip, mouseX, mouseY);
        }
    }

    protected void renderMain(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        this.setTooltip(null);
        this.fieldList.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280653_(this.f_96547_, this.SUBTITLE, this.f_96543_ / 2, 24, 0x777777);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    protected void renderPopup(GuiGraphics graphics, AbstractWidget popup, int mouseX, int mouseY, float partialTicks) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(0.0, 0.0, 40.0);
        graphics.m_280024_(0, 0, this.f_96543_, this.f_96544_, -1072689136, -804253680);
        this.setTooltip(null);
        popup.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280168_().m_85849_();
    }
}

