/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.client;

import fathertoast.crust.api.config.client.gui.screen.CrustConfigSelectScreen;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModLoadingContext;

public final class ClientConfigUtil {
    public static void registerConfigButtonAsEditScreen() {
        ModLoadingContext ctx = ModLoadingContext.get();
        String modId = ctx.getActiveNamespace();
        ConfigManager cfgManager = ConfigManager.get(modId);
        if (cfgManager == null) {
            ConfigUtil.LOG.warn("Mod '{}' attempted to assign a config button action, but has no config!", (Object)modId);
        } else {
            ctx.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, parent) -> new CrustConfigSelectScreen(null, cfgManager)));
        }
    }

    public static void registerConfigButtonAsOpenFolder() {
        ModLoadingContext ctx = ModLoadingContext.get();
        String modId = ctx.getActiveNamespace();
        ConfigManager cfgManager = ConfigManager.get(modId);
        if (cfgManager == null) {
            ConfigUtil.LOG.warn("Mod '{}' attempted to assign a config button action, but has no config!", (Object)modId);
        } else {
            ctx.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((mc, parent) -> new OpenFolderScreen(cfgManager)));
            MinecraftForge.EVENT_BUS.addListener(new OpenFolderHandler(cfgManager)::onGuiOpen);
        }
    }

    private static class OpenFolderHandler {
        final ConfigManager CFG_MANAGER;

        OpenFolderHandler(ConfigManager cfgManager) {
            this.CFG_MANAGER = cfgManager;
        }

        void onGuiOpen(ScreenEvent.Opening event) {
            if (event.getNewScreen() instanceof OpenFolderScreen && this.CFG_MANAGER.equals(((OpenFolderScreen)event.getNewScreen()).CFG_MANAGER)) {
                event.setCanceled(true);
                Util.m_137581_().m_137644_(this.CFG_MANAGER.DIR);
            }
        }
    }

    private static class OpenFolderScreen
    extends Screen {
        final ConfigManager CFG_MANAGER;

        OpenFolderScreen(ConfigManager cfgManager) {
            super((Component)Component.m_237113_((String)"Opening folder"));
            this.CFG_MANAGER = cfgManager;
        }
    }
}

