/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmaterials.resources;

import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public enum ResourceType {
    STONE_ORE(0, "{material} Ore", "ores", List.of("forge:ores", "forge:ores_in_ground/stone")),
    DEEPSLATE_ORE(1, "Deepslate {material} Ore", "ores", List.of("forge:ores", "forge:ores_in_ground/deepslate")),
    END_ORE(2, "Endstone {material} Ore", "ores", List.of("forge:ores", "forge:ores_in_ground/end")),
    NETHER_ORE(3, "Nether {material} Ore", "ores", List.of("forge:ores", "forge:ores_in_ground/nether")),
    BLOCK(4, "Block of {material}", "storage_blocks"),
    INGOT(5, "{material} Ingot", "ingots"),
    RAW_ORE(6, "Raw {material}", "raw_materials"),
    RAW_BLOCK(7, "Block of Raw {material}", "storage_blocks", List.of(), s -> "raw_" + s),
    NUGGET(8, "{material} Nugget", "nuggets"),
    DUST(9, "{material} Dust", "dusts"),
    PLATE(10, "{material} Plate", "plates"),
    GEAR(11, "{material} Gear", "gears"),
    ROD(12, "{material} Rod", "rods"),
    GEM(13, "{material}", "gems", List.of(), Function.identity(), null),
    CRYSTAL(14, "{material} Crystal", "crystals"),
    WIRE(15, "{material} Wire", "wires"),
    SHARD(16, "{material} Shard", "shards|mekanism:shards"),
    CLUMP(17, "{material} Clump", "clumps"),
    DIRTY_DUST(18, "{material} Dirty Dust", "dirty_dusts"),
    BLADE(19, "{material} Blade", "blades"),
    CHUNK(20, "{material} Chunk", "chunks"),
    CLUSTER(21, "{material} Cluster", "clusters"),
    SMALL_DUST(22, "Small {material} Dust", "small_dusts"),
    TINY_DUST(23, "Tiny {material} Dust", "tiny_dusts"),
    TINY(24, "Tiny {material}", "tiny");

    private final int id;
    @Nullable
    private final String unifiedTagPrefix;
    private final String translationText;
    @Nullable
    private final String resourceId;
    private List<String> tags = List.of();
    @Nullable
    private Function<String, String> resourceNameMutator = null;

    private ResourceType(int id, String translationText) {
        this.id = id;
        this.translationText = translationText;
        this.unifiedTagPrefix = null;
        this.resourceId = this.name();
    }

    private ResourceType(@Nullable int id, String translationText, String unifiedTagPrefix) {
        this.id = id;
        this.translationText = translationText;
        this.unifiedTagPrefix = unifiedTagPrefix;
        this.resourceId = this.name();
    }

    private ResourceType(@Nullable int id, String translationText, String unifiedTagPrefix, List<String> tags) {
        this.id = id;
        this.translationText = translationText;
        this.unifiedTagPrefix = unifiedTagPrefix;
        this.tags = tags;
        this.resourceId = this.name();
    }

    private ResourceType(@Nullable int id, String translationText, @Nullable String unifiedTagPrefix, List<String> tags, Function<String, String> unifiedPrefixMutator) {
        this.id = id;
        this.translationText = translationText;
        this.unifiedTagPrefix = unifiedTagPrefix;
        this.tags = tags;
        this.resourceNameMutator = unifiedPrefixMutator;
        this.resourceId = this.name();
    }

    private ResourceType(@Nullable int id, String translationText, @Nullable String unifiedTagPrefix, List<String> tags, Function<String, String> unifiedPrefixMutator, String resourceId) {
        this.id = id;
        this.translationText = translationText;
        this.unifiedTagPrefix = unifiedTagPrefix;
        this.tags = tags;
        this.resourceNameMutator = unifiedPrefixMutator;
        this.resourceId = resourceId;
    }

    public int getId() {
        return this.id;
    }

    @Nullable
    public String getUnifiedTagPrefix() {
        return this.unifiedTagPrefix;
    }

    public List<String> getTags() {
        return this.tags;
    }

    @Nullable
    public Function<String, String> getResourceNameMutator() {
        return this.resourceNameMutator;
    }

    public String getTranslationText() {
        return this.translationText;
    }

    @Nullable
    public String getResourceId() {
        return this.resourceId;
    }
}

