/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmaterials.resources;

import com.google.common.collect.ImmutableList;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.ftb.mods.ftbmaterials.registry.ModBlocks;
import dev.ftb.mods.ftbmaterials.registry.ModItems;
import dev.ftb.mods.ftbmaterials.resources.Resource;
import dev.ftb.mods.ftbmaterials.resources.ResourceRegistry;
import dev.ftb.mods.ftbmaterials.resources.ResourceType;
import it.unimi.dsi.fastutil.Pair;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class ResourceRegistryHolder {
    public static final Set<ResourceType> BLOCK_TYPES = Set.of(ResourceType.BLOCK, ResourceType.RAW_BLOCK, ResourceType.STONE_ORE, ResourceType.DEEPSLATE_ORE, ResourceType.END_ORE, ResourceType.NETHER_ORE);
    private final Resource type;
    private final List<RegistrySupplier<Block>> blocks = new LinkedList<RegistrySupplier<Block>>();
    private final List<RegistrySupplier<Item>> items = new LinkedList<RegistrySupplier<Item>>();
    private final Map<ResourceType, RegistrySupplier<Block>> componentToBlockRegister = new LinkedHashMap<ResourceType, RegistrySupplier<Block>>();
    private final Map<ResourceType, RegistrySupplier<Item>> componentToItemRegister = new LinkedHashMap<ResourceType, RegistrySupplier<Item>>();
    public final Map<RegistrySupplier<Block>, Pair<Resource, ResourceType>> reverseBlockLookup = new LinkedHashMap<RegistrySupplier<Block>, Pair<Resource, ResourceType>>();
    public final Map<RegistrySupplier<Item>, Pair<Resource, ResourceType>> reverseItemLookup = new LinkedHashMap<RegistrySupplier<Item>, Pair<Resource, ResourceType>>();

    public ResourceRegistryHolder(Resource type) {
        this.type = type;
        Set<ResourceType> components = this.type.getComponents();
        this.registerEntries(components);
    }

    private void registerEntries(Set<ResourceType> components) {
        for (ResourceType component : components) {
            Object niceName = this.type.name().toLowerCase();
            String resourceId = component.getResourceId();
            if (resourceId != null) {
                niceName = (String)niceName + "_" + resourceId.toLowerCase();
            }
            if (BLOCK_TYPES.contains((Object)component)) {
                RegistrySupplier regItem = ResourceRegistry.BLOCKS.register((String)niceName, () -> new Block(ModBlocks.DEFAULT_PROPS));
                RegistrySupplier blockItem = ResourceRegistry.ITEMS.register((String)niceName, () -> new BlockItem((Block)regItem.get(), ModItems.DEFAULT_PROPS));
                this.blocks.add((RegistrySupplier<Block>)regItem);
                this.componentToBlockRegister.put(component, (RegistrySupplier<Block>)regItem);
                this.componentToItemRegister.put(component, (RegistrySupplier<Item>)blockItem);
                this.reverseBlockLookup.put((RegistrySupplier<Block>)regItem, (Pair<Resource, ResourceType>)Pair.of((Object)((Object)this.type), (Object)((Object)component)));
                this.reverseItemLookup.put((RegistrySupplier<Item>)blockItem, (Pair<Resource, ResourceType>)Pair.of((Object)((Object)this.type), (Object)((Object)component)));
                continue;
            }
            RegistrySupplier regBlock = ResourceRegistry.ITEMS.register((String)niceName, () -> new Item(ModItems.DEFAULT_PROPS));
            this.items.add((RegistrySupplier<Item>)regBlock);
            this.componentToItemRegister.put(component, (RegistrySupplier<Item>)regBlock);
            this.reverseItemLookup.put((RegistrySupplier<Item>)regBlock, (Pair<Resource, ResourceType>)Pair.of((Object)((Object)this.type), (Object)((Object)component)));
        }
    }

    public Optional<RegistrySupplier<Block>> getBlockFromType(ResourceType type) {
        return Optional.ofNullable(this.componentToBlockRegister.get((Object)type));
    }

    public Optional<RegistrySupplier<Item>> getItemFromType(ResourceType type) {
        return Optional.ofNullable(this.componentToItemRegister.get((Object)type));
    }

    public ImmutableList<RegistrySupplier<Block>> getBlocks() {
        return ImmutableList.copyOf(this.blocks);
    }

    public ImmutableList<RegistrySupplier<Item>> getItems() {
        return ImmutableList.copyOf(this.items);
    }

    public Resource getType() {
        return this.type;
    }

    public Map<RegistrySupplier<Block>, Pair<Resource, ResourceType>> getReverseBlockLookup() {
        return this.reverseBlockLookup;
    }

    public Map<RegistrySupplier<Item>, Pair<Resource, ResourceType>> getReverseItemLookup() {
        return this.reverseItemLookup;
    }

    public void clearReverseLookups() {
        this.reverseBlockLookup.clear();
        this.reverseItemLookup.clear();
    }
}

