/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmaterials.resources;

import dev.architectury.registry.registries.DeferredRegister;
import dev.ftb.mods.ftbmaterials.resources.Resource;
import dev.ftb.mods.ftbmaterials.resources.ResourceRegistryHolder;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceRegistry.class);
    static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"ftbmaterials", (ResourceKey)Registries.f_256747_);
    static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"ftbmaterials", (ResourceKey)Registries.f_256913_);
    public static final Set<ResourceRegistryHolder> RESOURCE_REGISTRY_HOLDERS = new LinkedHashSet<ResourceRegistryHolder>();

    public static void init() {
        LOGGER.info("Initializing resource registry holders");
        for (Resource type : Resource.values()) {
            ResourceRegistryHolder holder = ResourceRegistry.create(type);
            RESOURCE_REGISTRY_HOLDERS.add(holder);
        }
        BLOCKS.register();
        ITEMS.register();
    }

    private static ResourceRegistryHolder create(Resource type) {
        return new ResourceRegistryHolder(type);
    }

    public static Optional<ResourceRegistryHolder> get(Resource type) {
        for (ResourceRegistryHolder holder : RESOURCE_REGISTRY_HOLDERS) {
            if (holder.getType() != type) continue;
            return Optional.of(holder);
        }
        return Optional.empty();
    }
}

