/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmaterials.resources;

import dev.ftb.mods.ftbmaterials.resources.ResourceType;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public enum Resource {
    ALUMINUM(Resource.builder().noGem().noTiny().build()),
    APATITE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    BRONZE(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().noTiny().build()),
    CHARCOAL(Resource.builder().noOres().noIngot().noRawOre().noWire().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().build()),
    CONSTANTAN(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noTiny().build()),
    COPPER(Resource.builder().noDeepslateOre().noStoneOre().noBlock().noIngot().noRawOre().noRawBlock().noGem().noTiny().build()),
    DIAMOND(new ResourceLocation("needs_iron_tool"), Resource.builder().noGem().noBlock().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noBlade().noTiny().build()),
    ELECTRUM(Resource.builder().noOres().noRawOre().noRawBlock().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noTiny().build()),
    GOLD(new ResourceLocation("needs_iron_tool"), Resource.builder().noDeepslateOre().noStoneOre().noBlock().noIngot().noNugget().noRawOre().noRawBlock().noBlade().noTiny().build()),
    GRAPHITE(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noTiny().build()),
    INVAR(new ResourceLocation("needs_iron_tool"), Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noTiny().build()),
    IRON(Resource.builder().noRawOre().noStoneOre().noDeepslateOre().noRawBlock().noBlock().noIngot().noNugget().noGem().noTiny().build()),
    LEAD(Resource.builder().noGem().noBlade().noTiny().build()),
    LUMIUM(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noBlade().noChunk().noCluster().noTiny().build()),
    NETHERITE(new ResourceLocation("needs_diamond_tool"), Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noIngot().noBlock().noChunk().noCluster().noTiny().build()),
    NICKEL(Resource.builder().noGem().noBlade().noTiny().build()),
    OBSIDIAN(Resource.builder().noOres().noIngot().noRawOre().noRawBlock().noNugget().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noBlock().noChunk().noCluster().noTiny().build()),
    OSMIUM(new ResourceLocation("needs_iron_tool"), Resource.builder().noGem().noBlade().noTiny().build()),
    QUARTZ(Resource.builder().noCrystal().noBlock().noNetherOre().noIngot().noRawOre().noRawBlock().noGem().noBlade().noTiny().build()),
    REFINED_GLOWSTONE(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noChunk().noCluster().noTiny().build()),
    SIGNALUM(Resource.builder().noOres().noBlock().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    SILVER(Resource.builder().noBlade().noTiny().build()),
    STEEL(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noTiny().build()),
    SULFUR(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    TIN(Resource.builder().noGem().noTiny().build()),
    URANIUM(Resource.builder().noGem().noBlade().noTiny().build()),
    ZINC(Resource.builder().noGem().noBlade().noTiny().build()),
    REDSTONE(new ResourceLocation("needs_iron_tool"), Resource.builder().noBlock().noDust().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noTiny().build()),
    FLUORITE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noTiny().build()),
    EMERALD(new ResourceLocation("needs_iron_tool"), Resource.builder().noGem().noBlock().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noNugget().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noSmallDust().noTiny().build()),
    LAPIS_LAZULI(Resource.builder().noGem().noBlock().noDeepslateOre().noStoneOre().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noSmallDust().noTiny().build()),
    RESONATING_ORE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    DIMENSIONAL_SHARD(new ResourceLocation("needs_iron_tool"), Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noDust().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    ANTIMONY(Resource.builder().noPlate().noGear().noRod().noGem().noBlade().noChunk().noCluster().noTiny().build()),
    BAUXITE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noTiny().build()),
    IRIDIUM(Resource.builder().noGear().noRod().noGem().noBlade().noChunk().noCluster().noTiny().build()),
    MONAZITE(Resource.builder().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noTiny().build()),
    TUNGSTEN(Resource.builder().noGear().noGem().noBlade().noChunk().noCluster().noTiny().build()),
    TITANIUM(Resource.builder().noGem().noChunk().noCluster().noTiny().build()),
    PLATINUM(Resource.builder().noGem().noBlade().noTiny().build()),
    STAINLESS_STEEL(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().noTiny().build()),
    PLUTONIUM(Resource.builder().noOres().noChunk().noCluster().noTiny().build()),
    CHROMIUM(Resource.builder().noOres().noChunk().noCluster().noTiny().build()),
    SILICON(Resource.builder().noOres().noChunk().noCluster().noTiny().build()),
    BRASS(Resource.builder().noOres().noChunk().noCluster().noTiny().build()),
    COAL(Resource.builder().noStoneOre().noDeepslateOre().noBlock().noIngot().noRawOre().noRawBlock().noNugget().noGem().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().noBlade().noGear().noRod().noWire().noSmallDust().noTinyDust().build()),
    CINNABAR(Resource.builder().noIngot().noRawOre().noRawBlock().noWire().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    NITER(Resource.builder().noIngot().noRawOre().noRawBlock().noWire().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    RUBY(Resource.builder().noIngot().noRawOre().noRawBlock().noWire().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().build()),
    SALT(Resource.builder().noIngot().noRawOre().noRawBlock().noWire().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTiny().build()),
    SAPPHIRE(Resource.builder().noIngot().noRawOre().noRawBlock().noWire().noNugget().noPlate().noGear().noRod().noCrystal().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTiny().build()),
    COAL_COKE(Resource.builder().noOres().noIngot().noRawOre().noRawBlock().noNugget().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().noBlade().noGear().noRod().noWire().noPlate().noSmallDust().noTinyDust().noTiny().build()),
    REFINED_OBSIDIAN(Resource.builder().noOres().noRawOre().noRawBlock().noGem().noCrystal().noShard().noClump().noDirtyDust().noChunk().noCluster().noBlade().noGear().noRod().noWire().noPlate().noSmallDust().noTinyDust().noTiny().build()),
    SAW(Resource.builder().noOres().noStoneOre().noDeepslateOre().noEndOre().noNetherOre().noBlock().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noWire().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    LITHIUM(Resource.builder().noOres().noStoneOre().noDeepslateOre().noEndOre().noNetherOre().noBlock().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noWire().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noTiny().build()),
    TOPAZ(Resource.builder().noOres().noStoneOre().noDeepslateOre().noEndOre().noNetherOre().noBlock().noIngot().noRawOre().noRawBlock().noNugget().noPlate().noGear().noRod().noGem().noCrystal().noWire().noShard().noClump().noDirtyDust().noBlade().noChunk().noCluster().noSmallDust().noTinyDust().noDust().build());

    private final int resourceComponents;
    private ResourceLocation breakableWith = new ResourceLocation("minecraft", "needs_stone_tool");

    private Resource(int resourceComponents) {
        this.resourceComponents = resourceComponents;
    }

    private Resource(ResourceLocation breakableWith, int resourceComponents) {
        this.resourceComponents = resourceComponents;
        this.breakableWith = breakableWith;
    }

    public boolean hasComponent(ResourceType type) {
        return (this.resourceComponents & 1 << type.getId()) != 0;
    }

    public Set<ResourceType> getComponents() {
        HashSet<ResourceType> types = new HashSet<ResourceType>();
        for (ResourceType type : ResourceType.values()) {
            if (!this.hasComponent(type)) continue;
            types.add(type);
        }
        return types;
    }

    public ResourceLocation getBreakableWith() {
        return this.breakableWith;
    }

    private static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    private static class ResourceBuilder {
        private int resourceComponents = 0;

        public ResourceBuilder() {
            for (ResourceType type : ResourceType.values()) {
                this.resourceComponents |= 1 << type.getId();
            }
        }

        public ResourceBuilder noType(ResourceType type) {
            this.resourceComponents &= ~(1 << type.getId());
            return this;
        }

        public ResourceBuilder noOres() {
            return this.noStoneOre().noDeepslateOre().noEndOre().noNetherOre();
        }

        public ResourceBuilder noStoneOre() {
            return this.noType(ResourceType.STONE_ORE);
        }

        public ResourceBuilder noDeepslateOre() {
            return this.noType(ResourceType.DEEPSLATE_ORE);
        }

        public ResourceBuilder noEndOre() {
            return this.noType(ResourceType.END_ORE);
        }

        public ResourceBuilder noNetherOre() {
            return this.noType(ResourceType.NETHER_ORE);
        }

        public ResourceBuilder noBlock() {
            return this.noType(ResourceType.BLOCK);
        }

        public ResourceBuilder noIngot() {
            return this.noType(ResourceType.INGOT);
        }

        public ResourceBuilder noRawOre() {
            return this.noType(ResourceType.RAW_ORE);
        }

        public ResourceBuilder noRawBlock() {
            return this.noType(ResourceType.RAW_BLOCK);
        }

        public ResourceBuilder noNugget() {
            return this.noType(ResourceType.NUGGET);
        }

        public ResourceBuilder noDust() {
            return this.noType(ResourceType.DUST);
        }

        public ResourceBuilder noPlate() {
            return this.noType(ResourceType.PLATE);
        }

        public ResourceBuilder noGear() {
            return this.noType(ResourceType.GEAR);
        }

        public ResourceBuilder noRod() {
            return this.noType(ResourceType.ROD);
        }

        public ResourceBuilder noGem() {
            return this.noType(ResourceType.GEM);
        }

        public ResourceBuilder noCrystal() {
            return this.noType(ResourceType.CRYSTAL);
        }

        public ResourceBuilder noWire() {
            return this.noType(ResourceType.WIRE);
        }

        public ResourceBuilder noShard() {
            return this.noType(ResourceType.SHARD);
        }

        public ResourceBuilder noClump() {
            return this.noType(ResourceType.CLUMP);
        }

        public ResourceBuilder noDirtyDust() {
            return this.noType(ResourceType.DIRTY_DUST);
        }

        public ResourceBuilder noBlade() {
            return this.noType(ResourceType.BLADE);
        }

        public ResourceBuilder noChunk() {
            return this.noType(ResourceType.CHUNK);
        }

        public ResourceBuilder noCluster() {
            return this.noType(ResourceType.CLUSTER);
        }

        public ResourceBuilder noSmallDust() {
            return this.noType(ResourceType.SMALL_DUST);
        }

        public ResourceBuilder noTinyDust() {
            return this.noType(ResourceType.TINY_DUST);
        }

        public ResourceBuilder noTiny() {
            return this.noType(ResourceType.TINY);
        }

        public int build() {
            return this.resourceComponents;
        }
    }
}

