/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbmaterials.dev.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.ftb.mods.ftbmaterials.resources.Resource;
import dev.ftb.mods.ftbmaterials.resources.ResourceRegistry;
import dev.ftb.mods.ftbmaterials.resources.ResourceRegistryHolder;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructAllResources {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConstructAllResources.class);

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"construct-all-resources").requires(e -> e.m_6761_(4))).executes(ConstructAllResources::construct);
    }

    private static int construct(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos pos = player.m_20183_();
        int xOffset = 0;
        int yOffset = 0;
        for (Resource resource : Resource.values()) {
            Optional<ResourceRegistryHolder> resourceHolder = ResourceRegistry.RESOURCE_REGISTRY_HOLDERS.stream().filter(e -> e.getType().equals((Object)resource)).findFirst();
            if (resourceHolder.isEmpty()) {
                LOGGER.warn("Unable to find {} in registry holders", (Object)resource);
                continue;
            }
            ResourceRegistryHolder resourceRegistryHolder = resourceHolder.get();
            for (RegistrySupplier block : resourceRegistryHolder.getBlocks()) {
                Block actualBlock = (Block)block.get();
                level.m_7731_(pos.m_5484_(Direction.UP, yOffset).m_5484_(Direction.NORTH, xOffset), actualBlock.m_49966_(), 3);
                ++yOffset;
            }
            for (RegistrySupplier item : resourceRegistryHolder.getItems()) {
                BlockPos relativeLocation = pos.m_5484_(Direction.UP, yOffset).m_5484_(Direction.NORTH, xOffset);
                level.m_7731_(relativeLocation, Blocks.f_50069_.m_49966_(), 3);
                ItemFrame itemFrame = new ItemFrame((Level)level, relativeLocation.m_121945_(Direction.EAST), Direction.EAST);
                ItemStack itemStack = new ItemStack((ItemLike)item.get());
                itemStack.m_41714_(((Item)item.get()).m_7626_(itemStack));
                itemFrame.m_31805_(itemStack);
                itemFrame.m_20340_(true);
                level.m_7967_((Entity)itemFrame);
                ++yOffset;
            }
            ++xOffset;
            yOffset = 0;
        }
        return 0;
    }
}

