/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.InventoryUtil;
import dev.tr7zw.firstperson.access.AgeableListModelAccess;
import dev.tr7zw.firstperson.access.PlayerModelAccess;
import dev.tr7zw.firstperson.versionless.mixinbase.ModelPartBase;
import dev.tr7zw.transition.mc.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.VillagerHeadModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin {
    private static List<Runnable> revert = new ArrayList<Runnable>();

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;setupAnim(Lnet/minecraft/world/entity/Entity;FFFFF)V", shift=At.Shift.AFTER)}, cancellable=true)
    public void renderPostAnim(LivingEntity livingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo info) {
        float offset;
        Player player;
        if (!revert.isEmpty()) {
            for (Runnable r : revert) {
                r.run();
            }
            revert.clear();
        }
        if (!FirstPersonModelCore.instance.isRenderingPlayer()) {
            return;
        }
        if (livingEntity instanceof Shulker) {
            return;
        }
        EntityModel model = this.m_7200_();
        boolean headShouldBeHidden = false;
        if (model instanceof AgeableListModelAccess) {
            AgeableListModelAccess agable = (AgeableListModelAccess)model;
            agable.firstPersonHeadPartsGetter().forEach(part -> {
                ((ModelPartBase)part).setHidden();
                revert.add(() -> ((ModelPartBase)part).showAgain());
            });
            headShouldBeHidden = true;
        }
        if (model instanceof HeadedModel) {
            HeadedModel headed = (HeadedModel)model;
            ((ModelPartBase)headed.m_5585_()).setHidden();
            revert.add(() -> ((ModelPartBase)headed.m_5585_()).showAgain());
            headShouldBeHidden = true;
        }
        if (model instanceof HumanoidModel) {
            HumanoidModel humanModel = (HumanoidModel)model;
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                if (FirstPersonModelCore.instance.getLogicHandler().hideArmsAndItems(livingEntity)) {
                    ((ModelPartBase)humanModel.f_102812_).setHidden();
                    ((ModelPartBase)humanModel.f_102811_).setHidden();
                    revert.add(() -> {
                        ((ModelPartBase)humanModel.f_102812_).showAgain();
                        ((ModelPartBase)humanModel.f_102811_).showAgain();
                    });
                } else if (FirstPersonModelCore.instance.getLogicHandler().dynamicHandsEnabled()) {
                    offset = Mth.m_14036_((float)(-EntityUtil.getXRot((Entity)Minecraft.m_91087_().f_91074_) / 20.0f + 2.0f), (float)-0.0f, (float)0.7f);
                    humanModel.f_102811_.f_104203_ += offset;
                    humanModel.f_102812_.f_104203_ += offset;
                    if (!FirstPersonModelCore.instance.getLogicHandler().lookingDown()) {
                        if (!InventoryUtil.getOffhand(InventoryUtil.getInventory(player)).m_41619_() || livingEntity.m_21205_().m_41720_().equals(Items.f_42573_)) {
                            ((ModelPartBase)humanModel.f_102812_).setHidden();
                            revert.add(() -> ((ModelPartBase)humanModel.f_102812_).showAgain());
                        }
                        if (!InventoryUtil.getSelected(InventoryUtil.getInventory(player)).m_41619_()) {
                            ((ModelPartBase)humanModel.f_102811_).setHidden();
                            revert.add(() -> ((ModelPartBase)humanModel.f_102811_).showAgain());
                        }
                    }
                }
            }
        }
        if (model instanceof VillagerHeadModel) {
            VillagerHeadModel villaterHead = (VillagerHeadModel)model;
            villaterHead.m_7491_(false);
            revert.add(() -> villaterHead.m_7491_(true));
        }
        if (model instanceof PlayerModel) {
            PlayerModel playerModel = (PlayerModel)model;
            headShouldBeHidden = true;
            ((ModelPartBase)playerModel.f_102809_).setHidden();
            revert.add(() -> ((ModelPartBase)playerModel.f_102809_).showAgain());
            if (livingEntity instanceof Player) {
                player = (Player)livingEntity;
                if (FirstPersonModelCore.instance.getLogicHandler().hideArmsAndItems(livingEntity)) {
                    ((ModelPartBase)playerModel.f_103374_).setHidden();
                    ((ModelPartBase)playerModel.f_103375_).setHidden();
                    revert.add(() -> {
                        ((ModelPartBase)playerModel.f_103374_).showAgain();
                        ((ModelPartBase)playerModel.f_103375_).showAgain();
                    });
                } else if (FirstPersonModelCore.instance.getLogicHandler().dynamicHandsEnabled()) {
                    offset = Mth.m_14036_((float)(-EntityUtil.getXRot((Entity)Minecraft.m_91087_().f_91074_) / 20.0f + 2.0f), (float)-0.0f, (float)0.7f);
                    playerModel.f_103375_.f_104203_ += offset;
                    playerModel.f_103374_.f_104203_ += offset;
                    if (!FirstPersonModelCore.instance.getLogicHandler().lookingDown()) {
                        if (!InventoryUtil.getOffhand(InventoryUtil.getInventory(player)).m_41619_() || livingEntity.m_21205_().m_41720_().equals(Items.f_42573_)) {
                            ((ModelPartBase)playerModel.f_103374_).setHidden();
                            revert.add(() -> ((ModelPartBase)playerModel.f_103374_).showAgain());
                        }
                        if (!InventoryUtil.getSelected(InventoryUtil.getInventory(player)).m_41619_()) {
                            ((ModelPartBase)playerModel.f_103375_).setHidden();
                            revert.add(() -> ((ModelPartBase)playerModel.f_103375_).showAgain());
                        }
                    }
                }
            }
        }
        if (livingEntity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player2 = (AbstractClientPlayer)livingEntity;
            EntityModel entityModel = model;
            if (entityModel instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)entityModel;
                if (FirstPersonModelCore.instance.getLogicHandler().isSwimming((Player)player2)) {
                    ((ModelPartBase)playerModel.f_102810_).setHidden();
                    ((ModelPartBase)((PlayerModelAccess)model).getCloak()).setHidden();
                    revert.add(() -> LivingEntityRendererMixin.lambda$renderPostAnim$11(playerModel, (Model)model));
                }
            }
        }
        if (!headShouldBeHidden) {
            matrixStack.m_85849_();
            info.cancel();
        }
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    public void renderReturn(LivingEntity livingEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, CallbackInfo info) {
        if (!revert.isEmpty()) {
            for (Runnable r : revert) {
                r.run();
            }
            revert.clear();
        }
        FirstPersonModelCore.instance.setRenderingPlayer(false);
    }

    @Shadow
    public abstract EntityModel m_7200_();

    private static /* synthetic */ void lambda$renderPostAnim$11(PlayerModel playerModel, Model model) {
        ((ModelPartBase)playerModel.f_102810_).showAgain();
        ((ModelPartBase)((PlayerModelAccess)model).getCloak()).showAgain();
    }
}

