/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.firstperson;

import dev.tr7zw.firstperson.FirstPersonModelCore;
import dev.tr7zw.firstperson.InventoryUtil;
import dev.tr7zw.firstperson.api.ActivationHandler;
import dev.tr7zw.firstperson.api.FirstPersonAPI;
import dev.tr7zw.firstperson.versionless.FirstPersonBase;
import dev.tr7zw.firstperson.versionless.config.VanillaHands;
import dev.tr7zw.transition.mc.EntityUtil;
import dev.tr7zw.transition.mc.GeneralUtil;
import dev.tr7zw.transition.mc.ItemUtil;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class LogicHandler {
    private final Minecraft client;
    private final FirstPersonModelCore fpm;
    private Vec3 offset = Vec3.f_82478_;
    private Set<Item> autoVanillaHandItems = new HashSet<Item>();
    private Set<Item> autoDisableItems = new HashSet<Item>();
    private long timeout = 0L;

    void registerDefaultHandlers() {
        FirstPersonAPI.registerPlayerHandler(() -> {
            if (this.client.f_91074_.m_5803_() || this.client.f_91074_.m_21209_() || this.client.f_91074_.m_21255_() || this.client.f_91074_.m_20998_(1.0f) != 0.0f && !this.isCrawlingOrSwimming((Player)this.client.f_91074_)) {
                this.timeout = System.currentTimeMillis() + 100L;
                return true;
            }
            if (System.currentTimeMillis() < this.timeout) {
                return true;
            }
            if (this.autoDisableItems.contains(this.client.f_91074_.m_21205_().m_41720_()) || this.autoDisableItems.contains(this.client.f_91074_.m_21206_().m_41720_())) {
                return true;
            }
            return this.client.f_91074_.m_150108_();
        });
    }

    public boolean shouldApplyThirdPerson(boolean thirdPerson) {
        if (!this.fpm.isEnabled() || thirdPerson) {
            return false;
        }
        for (ActivationHandler handler : FirstPersonAPI.getActivationHandlers()) {
            if (!handler.preventFirstperson()) continue;
            return false;
        }
        return true;
    }

    public void updatePositionOffset(Entity entity, float delta) {
        this.offset = Vec3.f_82478_;
        if (entity == this.client.m_91288_() && this.client.f_91074_.m_5803_()) {
            return;
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (entity != this.client.f_91074_ || this.client.f_91066_.m_92176_() != CameraType.FIRST_PERSON || !this.fpm.isRenderingPlayer()) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)entity;
        double realYaw = Mth.m_14189_((float)delta, (float)player.f_20884_, (float)player.f_20883_);
        if (!player.m_7578_() || this.client.m_91288_() == player) {
            float bodyOffset;
            if (this.isCrawlingOrSwimming((Player)this.client.f_91074_)) {
                player.f_20883_ = player.f_20885_;
                bodyOffset = player.f_19860_ > 0.0f ? 0.6f : 0.5f;
            } else if (player.m_6047_() || player.m_20089_() == Pose.CROUCHING) {
                bodyOffset = 0.27f + (float)this.fpm.getConfig().sneakXOffset / 100.0f;
            } else if (player.m_20159_()) {
                if (player.m_20202_() instanceof Boat || player.m_20202_() instanceof Minecart) {
                    realYaw = Mth.m_14189_((float)delta, (float)player.f_20884_, (float)player.f_20883_);
                } else {
                    Entity entity2 = player.m_20202_();
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity2;
                        realYaw = LogicHandler.calculateBodyRot(Mth.m_14189_((float)delta, (float)living.f_20884_, (float)living.f_20883_), EntityUtil.getYRot((Entity)player));
                    }
                }
                bodyOffset = 0.2f + (float)this.fpm.getConfig().sitXOffset / 100.0f;
            } else {
                bodyOffset = 0.25f + (float)this.fpm.getConfig().xOffset / 100.0f;
            }
            x += (double)bodyOffset * Math.sin(Math.toRadians(realYaw));
            z -= (double)bodyOffset * Math.cos(Math.toRadians(realYaw));
            if (this.isCrawlingOrSwimming((Player)this.client.f_91074_)) {
                y = player.f_19860_ > 0.0f && player.m_5842_() ? (y += (double)0.6f * Math.sin(Math.toRadians(player.f_19860_))) : (y += (double)0.01f * -Math.sin(Math.toRadians(player.f_19860_)));
            }
        }
        this.offset = new Vec3(x, y, z);
    }

    private static float calculateBodyRot(float entityBodyRot, float riderHeadRot) {
        float wrappedHeadRot = Mth.m_14177_((float)riderHeadRot);
        float rotDiff = Mth.m_14177_((float)(wrappedHeadRot - entityBodyRot));
        if (Mth.m_14154_((float)rotDiff) > 50.0f) {
            entityBodyRot = wrappedHeadRot - 50.0f * Math.signum(rotDiff);
        }
        entityBodyRot = Mth.m_14177_((float)entityBodyRot);
        return entityBodyRot;
    }

    public boolean isSwimming(Player player) {
        return player.m_6069_();
    }

    public boolean isCrawlingOrSwimming(Player player) {
        return player.m_6067_();
    }

    public boolean showVanillaHands() {
        return this.showVanillaHands((LivingEntity)this.client.f_91074_);
    }

    public boolean showVanillaHands(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return this.showVanillaHands(InventoryUtil.getSelected(InventoryUtil.getInventory(player)), InventoryUtil.getOffhand(InventoryUtil.getInventory(player)));
        }
        return false;
    }

    public boolean showVanillaHands(ItemStack mainhand, ItemStack offhand) {
        return this.fpm.getConfig().vanillaHandsMode == VanillaHands.ALL || this.fpm.getConfig().vanillaHandsMode == VanillaHands.ALL_DOUBLE || this.fpm.getConfig().vanillaHandsMode == VanillaHands.ITEMS && (!mainhand.m_41619_() || !offhand.m_41619_()) || this.autoVanillaHandItems.contains(mainhand.m_41720_()) || this.autoVanillaHandItems.contains(offhand.m_41720_()) || this.autoDisableItems.contains(mainhand.m_41720_()) || this.autoDisableItems.contains(offhand.m_41720_());
    }

    public boolean hideArmsAndItems() {
        return this.hideArmsAndItems((LivingEntity)this.client.f_91074_);
    }

    public boolean hideArmsAndItems(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return this.hideArmsAndItems(livingEntity, InventoryUtil.getSelected(InventoryUtil.getInventory(player)), InventoryUtil.getOffhand(InventoryUtil.getInventory(player)));
        }
        return false;
    }

    public boolean hideArmsAndItems(LivingEntity livingEntity, ItemStack mainhand, ItemStack offhand) {
        Player player;
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming && livingEntity instanceof Player && this.isSwimming(player = (Player)livingEntity)) {
            return false;
        }
        if (this.lookingDown()) {
            return false;
        }
        return this.fpm.getConfig().vanillaHandsMode != VanillaHands.OFF || this.autoVanillaHandItems.contains(mainhand.m_41720_()) || this.autoVanillaHandItems.contains(offhand.m_41720_()) || this.autoDisableItems.contains(mainhand.m_41720_()) || this.autoDisableItems.contains(offhand.m_41720_());
    }

    public boolean dynamicHandsEnabled() {
        return this.dynamicHandsEnabled((LivingEntity)this.client.f_91074_);
    }

    public boolean dynamicHandsEnabled(LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            return this.dynamicHandsEnabled(livingEntity, InventoryUtil.getSelected(InventoryUtil.getInventory(player)), InventoryUtil.getOffhand(InventoryUtil.getInventory(player)));
        }
        return false;
    }

    public boolean dynamicHandsEnabled(LivingEntity livingEntity, ItemStack mainhand, ItemStack offhand) {
        Player player;
        if (FirstPersonModelCore.instance.getConfig().vanillaHandsSkipSwimming && livingEntity instanceof Player && this.isSwimming(player = (Player)livingEntity)) {
            return false;
        }
        return this.fpm.getConfig().dynamicMode && this.fpm.getConfig().vanillaHandsMode != VanillaHands.OFF && !this.autoVanillaHandItems.contains(mainhand.m_41720_()) && !this.autoVanillaHandItems.contains(offhand.m_41720_()) && !this.autoDisableItems.contains(mainhand.m_41720_()) && !this.autoDisableItems.contains(offhand.m_41720_());
    }

    public boolean lookingDown() {
        return this.dynamicHandsEnabled() && EntityUtil.getXRot((Entity)Minecraft.m_91087_().f_91074_) > 30.0f;
    }

    public void addAutoVanillaHandsItem(Item item) {
        this.autoVanillaHandItems.add(item);
    }

    public void addAutoDisableItem(Item item) {
        this.autoDisableItems.add(item);
    }

    public void reloadAutoVanillaHandsSettings() {
        Item item;
        this.autoVanillaHandItems.clear();
        this.autoDisableItems.clear();
        Item invalid = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)"minecraft", (String)"air"));
        for (String itemId : this.fpm.getConfig().autoVanillaHands) {
            try {
                item = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)itemId.split(":")[0], (String)itemId.split(":")[1]));
                if (invalid == item) continue;
                this.addAutoVanillaHandsItem(item);
            }
            catch (Exception ex) {
                FirstPersonBase.LOGGER.info("Unknown item to add to the auto vanilla hold list: {}", (Object)itemId);
            }
        }
        FirstPersonBase.LOGGER.info("Loaded Vanilla Hands items: {}", this.autoVanillaHandItems);
        for (String itemId : this.fpm.getConfig().autoToggleModItems) {
            try {
                item = ItemUtil.getItem((ResourceLocation)GeneralUtil.getResourceLocation((String)itemId.split(":")[0], (String)itemId.split(":")[1]));
                if (invalid == item) continue;
                this.addAutoDisableItem(item);
            }
            catch (Exception ex) {
                FirstPersonBase.LOGGER.info("Unknown item to add to the auto disable list: {}", (Object)itemId);
            }
        }
        FirstPersonBase.LOGGER.info("Loaded Auto Disable items: {}", this.autoDisableItems);
    }

    @Generated
    public LogicHandler(Minecraft client, FirstPersonModelCore fpm) {
        this.client = client;
        this.fpm = fpm;
    }

    @Generated
    public Vec3 getOffset() {
        return this.offset;
    }
}

