/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import net.minecraft.network.FriendlyByteBuf;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.platform.Services;
import nl.enjarai.doabarrelroll.util.ToastUtil;
import org.slf4j.Logger;

public class ServerConfigUpdateClient {
    private static boolean waitingForAck = false;

    public static void sendUpdate(ModConfigServer config) {
        FriendlyByteBuf buf = DoABarrelRoll.createBuf();
        buf.writeInt(1);
        try {
            String data = ((JsonElement)ModConfigServer.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config).getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).warn(arg_0))).toString();
            buf.m_130070_(data);
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.warn("Failed to send server config update to server: ", (Throwable)e);
        }
        Services.CLIENT_NET.sendPacket(DoABarrelRoll.SERVER_CONFIG_UPDATE_CHANNEL, buf);
        waitingForAck = true;
    }

    public static void updateAcknowledged(FriendlyByteBuf buf) {
        if (waitingForAck) {
            waitingForAck = false;
            try {
                boolean success;
                int protocolVersion = buf.readInt();
                if (protocolVersion != 1) {
                    DoABarrelRoll.LOGGER.warn("Received config update ack with unknown protocol version: {}, will attempt to read anyway", (Object)protocolVersion);
                }
                if (success = buf.readBoolean()) {
                    ToastUtil.toasty("server_config_updated");
                } else {
                    ToastUtil.toasty("server_config_update_failed");
                }
            }
            catch (RuntimeException e) {
                DoABarrelRoll.LOGGER.warn("Failed to read config update ack from server: ", (Throwable)e);
            }
        }
    }
}

