/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttconstruct.world;

import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.tree.species.Species;
import com.ferreusveritas.dynamictrees.util.LevelContext;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.DynamicTreeFeature;
import com.ferreusveritas.dynamictrees.worldgen.GenerationContext;
import com.mojang.serialization.Codec;
import java.util.concurrent.atomic.AtomicReference;
import maxhyper.dttconstruct.world.SpeciesFeatureConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import org.jetbrains.annotations.NotNull;

public class SingleDynamicTreeFeature
extends Feature<SpeciesFeatureConfiguration> {
    public SingleDynamicTreeFeature(Codec<SpeciesFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<SpeciesFeatureConfiguration> context) {
        Species species;
        LevelContext levelContext = LevelContext.create((LevelAccessor)context.m_159774_());
        ChunkPos chunkPos = context.m_159774_().m_46865_(context.m_159777_()).m_7697_();
        AtomicReference<Double> closestRingDistance = new AtomicReference<Double>(1024.0);
        AtomicReference<BlockPos> closestRing = new AtomicReference<BlockPos>(context.m_159777_());
        AtomicReference<Integer> closestRingRad = new AtomicReference<Integer>(0);
        DynamicTreeFeature.DISC_PROVIDER.getPoissonDiscs(levelContext, chunkPos).forEach(disc -> {
            BlockPos ringPos = new BlockPos(disc.x, context.m_159777_().m_123342_(), disc.z);
            double dist = context.m_159777_().m_123331_((Vec3i)ringPos);
            if (dist < (Double)closestRingDistance.get()) {
                closestRingDistance.set(dist);
                closestRing.set(ringPos);
                closestRingRad.set(disc.radius);
            }
        });
        boolean generate = true;
        BlockPos newOrigin = closestRing.get().m_7495_();
        if (TreeHelper.isTreePart((BlockState)levelContext.accessor().m_8055_(newOrigin.m_6630_(4)))) {
            generate = false;
        }
        if (!(species = ((SpeciesFeatureConfiguration)context.m_159778_()).getSpecies(levelContext, newOrigin)).isAcceptableSoilForWorldgen(context.m_159774_().m_8055_(newOrigin))) {
            newOrigin = newOrigin.m_7495_();
            if (!species.isAcceptableSoilForWorldgen(context.m_159774_().m_8055_(newOrigin))) {
                generate = false;
            }
        }
        if (!species.isValid()) {
            generate = false;
        }
        if (generate) {
            generate = this.generateTree(species, levelContext, newOrigin, closestRingRad.get());
        }
        BlockPos soil = context.m_159777_().m_7495_();
        if (!generate && species.isAcceptableSoilForWorldgen((LevelAccessor)levelContext.level(), soil, levelContext.accessor().m_8055_(soil))) {
            return this.generateTree(species, levelContext, soil, 2);
        }
        return generate;
    }

    private boolean generateTree(Species species, LevelContext context, BlockPos pos, int radius) {
        return species.generate(new GenerationContext(context, species, pos, pos.m_122032_(), context.accessor().m_204166_(pos), Direction.Plane.HORIZONTAL.m_235690_(context.accessor().m_213780_()), radius, SafeChunkBounds.ANY_WG));
    }
}

