/*
 * Decompiled with CFR 0.152.
 */
package maxhyper.dttconstruct.blocks;

import com.ferreusveritas.dynamictrees.DynamicTrees;
import com.ferreusveritas.dynamictrees.api.TreeHelper;
import com.ferreusveritas.dynamictrees.block.branch.BasicRootsBlock;
import com.ferreusveritas.dynamictrees.block.rooty.RootyBlock;
import com.ferreusveritas.dynamictrees.block.rooty.SoilHelper;
import com.ferreusveritas.dynamictrees.tree.family.Family;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import maxhyper.dttconstruct.trees.SlimeMangroveFamily;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import oshi.util.tuples.Pair;
import slimeknights.mantle.registration.object.EnumObject;
import slimeknights.tconstruct.fluids.TinkerFluids;
import slimeknights.tconstruct.world.TinkerWorld;
import slimeknights.tconstruct.world.block.DirtType;
import slimeknights.tconstruct.world.block.FoliageType;
import slimeknights.tconstruct.world.client.SlimeColorizer;

public class SlimeMangroveRootsBlock
extends BasicRootsBlock {
    public static final EnumProperty<DirtType> DIRT_TYPE = EnumProperty.m_61587_((String)"dirt_type", DirtType.class);
    public static final EnumProperty<GrassType> GRASS_TYPE = EnumProperty.m_61587_((String)"grass_type", GrassType.class);

    public SlimeMangroveRootsBlock(ResourceLocation name, BlockBehaviour.Properties properties) {
        super(name, properties.m_60977_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(GRASS_TYPE, (Comparable)((Object)GrassType.NONE))).m_61124_(DIRT_TYPE, (Comparable)DirtType.VANILLA));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{DIRT_TYPE}).m_61104_(new Property[]{GRASS_TYPE});
    }

    public SlimeMangroveFamily getFamily() {
        return (SlimeMangroveFamily)super.getFamily();
    }

    public Block getPrimitiveSlimeDirt(BlockState state) {
        if (!state.m_60713_((Block)this)) {
            return Blocks.f_50016_;
        }
        DirtType slime = (DirtType)state.m_61143_(DIRT_TYPE);
        GrassType grass = (GrassType)((Object)state.m_61143_(GRASS_TYPE));
        if (grass == GrassType.NONE) {
            return (Block)TinkerWorld.allDirt.get((Enum)slime);
        }
        return (Block)((EnumObject)TinkerWorld.slimeGrass.get(slime)).get((Enum)grass.asFoliage());
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.isFullBlock(state)) {
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)LAYER, (Comparable)BasicRootsBlock.Layer.FILLED)).m_61124_(GRASS_TYPE, (Comparable)((Object)GrassType.NONE)), level.f_46443_ ? 11 : 3);
            this.m_142387_(level, player, pos, state);
            level.m_142346_((Entity)player, GameEvent.f_157792_, pos);
            Block primitive = this.getPrimitiveSlimeDirt(state);
            if (!player.m_7500_() && primitive != null) {
                SlimeMangroveRootsBlock.m_49881_((BlockState)primitive.m_49966_(), (Level)level, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            }
            return false;
        }
        return this.removedByEntity(state, level, pos, (LivingEntity)player);
    }

    public int setRadius(LevelAccessor level, BlockPos pos, int radius, @Nullable Direction originDir, int flags) {
        Pair<DirtType, GrassType> pair;
        GrassType grassType;
        BasicRootsBlock.Layer layer;
        boolean isFullBlock;
        destroyMode = DynamicTrees.DestroyMode.SET_RADIUS;
        BlockState currentState = level.m_8055_(pos);
        boolean replacingWater = currentState.m_60819_() == this.getFluid(currentState).m_76068_(false);
        boolean replacingGround = this.getFamily().isAcceptableSoilForRootSystem(currentState);
        boolean setWaterlogged = replacingWater && !replacingGround;
        boolean bl = isFullBlock = radius >= 8;
        if (currentState.m_60713_((Block)this)) {
            layer = (BasicRootsBlock.Layer)currentState.m_61143_((Property)LAYER);
            if (layer == BasicRootsBlock.Layer.COVERED && isFullBlock) {
                layer = BasicRootsBlock.Layer.FILLED;
            }
        } else {
            layer = replacingGround ? BasicRootsBlock.Layer.COVERED : BasicRootsBlock.Layer.EXPOSED;
        }
        DirtType dirtType = currentState.m_60713_((Block)this) ? (DirtType)currentState.m_61143_(DIRT_TYPE) : DirtType.VANILLA;
        GrassType grassType2 = grassType = currentState.m_60713_((Block)this) ? (GrassType)((Object)currentState.m_61143_(GRASS_TYPE)) : GrassType.NONE;
        if (replacingGround && (pair = this.getSlimeFromState(currentState)) != null) {
            dirtType = (DirtType)pair.getA();
            if (this.canBeGrassy(level, pos) && !isFullBlock) {
                grassType = (GrassType)((Object)pair.getB());
            }
        }
        level.m_7731_(pos, (BlockState)((BlockState)((BlockState)((BlockState)this.getStateForRadius(radius).m_61124_((Property)LAYER, (Comparable)layer)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(setWaterlogged))).m_61124_(DIRT_TYPE, (Comparable)dirtType)).m_61124_(GRASS_TYPE, (Comparable)((Object)grassType)), flags);
        destroyMode = DynamicTrees.DestroyMode.SLOPPY;
        return radius;
    }

    protected boolean canBeGrassy(LevelAccessor level, BlockPos pos) {
        BlockPos upPos = pos.m_7494_();
        BlockState upState = level.m_8055_(upPos);
        return !upState.m_60838_((BlockGetter)level, upPos) && upState.m_60819_().m_76178_();
    }

    private Pair<DirtType, GrassType> getSlimeFromState(BlockState state1) {
        BlockState state = state1;
        if (SoilHelper.isSoilRegistered((Block)state.m_60734_()) && SoilHelper.getProperties((Block)state.m_60734_()).hasSubstitute() && SoilHelper.getProperties((Block)state.m_60734_()).getBlock().isPresent()) {
            state = ((RootyBlock)SoilHelper.getProperties((Block)state.m_60734_()).getBlock().get()).getPrimitiveSoilBlock().m_49966_();
        }
        for (Map.Entry entry : TinkerWorld.slimeGrass.entrySet()) {
            for (FoliageType type : FoliageType.values()) {
                if (!state.m_60713_((Block)((EnumObject)entry.getValue()).get((Enum)type))) continue;
                return new Pair((Object)((DirtType)entry.getKey()), (Object)GrassType.getFromFoliage(type));
            }
        }
        for (DirtType type : DirtType.TINKER) {
            if (!state.m_60713_((Block)TinkerWorld.slimeDirt.get((Enum)type))) continue;
            return new Pair((Object)type, (Object)GrassType.NONE);
        }
        return null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!this.isFullBlock(state)) {
            BlockState newState;
            BlockItem blockItem;
            Pair<DirtType, GrassType> coverProperties;
            ItemStack handStack;
            Item item;
            Object layer = BasicRootsBlock.Layer.COVERED;
            if ((Integer)state.m_61143_((Property)RADIUS) >= 8) {
                layer = state.m_61143_((Property)LAYER) == BasicRootsBlock.Layer.EXPOSED ? BasicRootsBlock.Layer.FILLED : null;
            }
            if (layer != null && (item = (handStack = player.m_21120_(hand)).m_41720_()) instanceof BlockItem && (coverProperties = this.getSlimeFromState((blockItem = (BlockItem)item).m_40614_().m_49966_())) != null && this.canPlace(player, level, pos, newState = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)LAYER, (Comparable)layer)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(DIRT_TYPE, (Comparable)((DirtType)coverProperties.getA()))).m_61124_(GRASS_TYPE, (Comparable)((Object)((GrassType)((Object)coverProperties.getB())))))) {
                level.m_7731_(pos, newState, 3);
                if (!player.m_7500_()) {
                    handStack.m_41774_(1);
                }
                level.m_5594_(null, pos, blockItem.m_40614_().getSoundType(state, (LevelReader)level, pos, (Entity)player).m_56777_(), SoundSource.BLOCKS, 1.0f, 0.8f);
                return InteractionResult.SUCCESS;
            }
        }
        ItemStack heldItem = player.m_21120_(hand);
        return TreeHelper.getTreePart((BlockState)state).getFamily(state, (BlockGetter)level, pos).onTreeActivated(new Family.TreeActivationContext(level, TreeHelper.findRootNode((Level)level, (BlockPos)pos), pos, state, player, hand, heldItem, hitResult)) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        return super.canSustainPlant(state, world, pos, facing, plantable) || state.m_61143_((Property)LAYER) == BasicRootsBlock.Layer.COVERED;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        if (state.m_61143_((Property)LAYER) == BasicRootsBlock.Layer.COVERED) {
            return this.getPrimitiveSlimeDirt(state).getSoundType(state, level, pos, entity);
        }
        return super.getSoundType(state, level, pos, entity);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        if (state.m_61143_((Property)LAYER) == BasicRootsBlock.Layer.COVERED) {
            return this.getPrimitiveSlimeDirt(state).getCloneItemStack(state, target, level, pos, player);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int foliageColorMultiplier(BlockState state, BlockAndTintGetter level, BlockPos pos) {
        GrassType grass = (GrassType)((Object)state.m_61143_(GRASS_TYPE));
        if (grass == GrassType.NONE) {
            return 1;
        }
        return SlimeColorizer.getColorForPos((BlockPos)pos, (FoliageType)grass.asFoliage());
    }

    public BlockState getStateForDecay(BlockState state, LevelAccessor level, BlockPos pos) {
        BasicRootsBlock.Layer layer;
        boolean waterlogged = state.m_61138_((Property)BlockStateProperties.f_61362_) && (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false;
        BasicRootsBlock.Layer layer2 = layer = state.m_61138_((Property)LAYER) ? (BasicRootsBlock.Layer)state.m_61143_((Property)LAYER) : BasicRootsBlock.Layer.EXPOSED;
        if (layer == BasicRootsBlock.Layer.COVERED) {
            return this.getPrimitiveSlimeDirt(state).m_49966_();
        }
        return waterlogged ? this.getFluid(state).m_76145_().m_76188_() : Blocks.f_50016_.m_49966_();
    }

    @Deprecated
    public float m_5880_(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        if (pState.m_61138_((Property)LAYER) && pState.m_61143_((Property)LAYER) == BasicRootsBlock.Layer.COVERED) {
            Block slimeDirt = this.getPrimitiveSlimeDirt(pState);
            return slimeDirt.m_5880_(slimeDirt.m_49966_(), pPlayer, pLevel, pPos);
        }
        return super.m_5880_(pState, pPlayer, pLevel, pPos);
    }

    private FlowingFluid getFluid(BlockState state) {
        return (FlowingFluid)TinkerFluids.enderSlime.get();
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? this.getFluid(state).m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)this.getFluid(stateIn), this.getFluid(stateIn).m_6718_((LevelReader)level));
        }
        return super.m_7417_(stateIn, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_6044_(BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return !this.isFullBlock(pState) && (Boolean)pState.m_61143_((Property)BlockStateProperties.f_61362_) == false && pFluid == this.getFluid(pState);
    }

    public static enum GrassType implements StringRepresentable
    {
        EARTH(FoliageType.EARTH),
        SKY(FoliageType.SKY),
        ICHOR(FoliageType.ICHOR),
        ENDER(FoliageType.ENDER),
        BLOOD(FoliageType.BLOOD),
        NONE(null);

        final FoliageType original;

        private GrassType(FoliageType original) {
            this.original = original;
        }

        public static GrassType getFromFoliage(FoliageType foliageType) {
            return Enum.valueOf(GrassType.class, foliageType.m_7912_().toUpperCase(Locale.ENGLISH));
        }

        public FoliageType asFoliage() {
            return this.original;
        }

        public String m_7912_() {
            if (this.original == null) {
                return this.toString().toLowerCase(Locale.ENGLISH);
            }
            return this.original.m_7912_();
        }
    }
}

