/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.mixin;

import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui.StorageInMotionTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.EntityStorageHolder;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.MovingStorageData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractChestedHorse.class})
public abstract class MixinAbstractChestedHorse
extends AbstractHorse
implements IMovingStorageEntity {
    @Unique
    private static final String STORAGE_HOLDER_TAG = "storageHolder";
    @Unique
    private final EntityStorageHolder<MixinAbstractChestedHorse> entityStorageHolder = new EntityStorageHolder<MixinAbstractChestedHorse>(this);
    @Unique
    private static final EntityDataAccessor<ItemStack> DATA_STORAGE_ITEM = SynchedEntityData.m_135353_(MixinAbstractChestedHorse.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    @Shadow
    public abstract boolean m_30502_();

    protected MixinAbstractChestedHorse(EntityType<? extends AbstractChestedHorse> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Shadow
    protected abstract void m_7609_();

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedStorageItem(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_STORAGE_ITEM, (Object)ItemStack.f_41583_);
    }

    @Inject(method={"dropEquipment"}, at={@At(value="TAIL")})
    private void dropStorageAndItsContents(CallbackInfo ci) {
        this.entityStorageHolder.onDestroy();
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addStorageHolderSaveData(CompoundTag tag, CallbackInfo ci) {
        if (this.hasStorageItem()) {
            tag.m_128365_(STORAGE_HOLDER_TAG, (Tag)this.entityStorageHolder.saveData());
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readStorageHolderSaveData(CompoundTag tag, CallbackInfo ci) {
        if (tag.m_128441_(STORAGE_HOLDER_TAG)) {
            this.entityStorageHolder.readData(tag.m_128469_(STORAGE_HOLDER_TAG));
        }
    }

    @Inject(method={"mobInteract"}, at={@At(value="HEAD")}, cancellable=true)
    private void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_30614_() && stack.m_41720_() instanceof StorageBlockItem && !this.hasStorageItem() && !this.m_30502_()) {
            ItemStack stackCopy = stack.m_255036_(1);
            this.entityStorageHolder.setStorageItemFrom(stackCopy, true);
            this.m_7609_();
            stack.m_41774_(1);
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
        } else if (this.m_30614_() && this.hasStorageItem() && stack.m_150930_(Items.f_42009_)) {
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Override
    public List<Slot> instantiateExtraSlots() {
        if (this.m_7482_()) {
            return List.of(new Slot((Container)this.f_30520_, 1, 8, 36){

                public boolean m_5857_(ItemStack stack) {
                    return MixinAbstractChestedHorse.this.m_6010_(stack);
                }
            });
        }
        if (this.m_6741_()) {
            return List.of(new Slot((Container)this.f_30520_, 0, 0, 0){

                public boolean m_5857_(ItemStack stack) {
                    return stack.m_150930_(Items.f_42450_) && !this.m_6657_() && MixinAbstractChestedHorse.this.m_6741_();
                }
            });
        }
        return Collections.emptyList();
    }

    private boolean hasStorageItem() {
        return !this.getStorageItem().m_41619_();
    }

    @Override
    public ItemStack getStorageItem() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_STORAGE_ITEM);
    }

    @Override
    public void setStorageItem(ItemStack storageItem) {
        this.f_19804_.m_135381_(DATA_STORAGE_ITEM, (Object)storageItem.m_41777_());
    }

    @Override
    public EntityStorageHolder<?> getStorageHolder() {
        return this.entityStorageHolder;
    }

    @Override
    public ItemStack getDropStack(ItemStack storageItem) {
        NBTHelper.getUniqueId((ItemStack)storageItem, (String)"uuid").ifPresent(storageId -> MovingStorageData.moveToItemStorage(storageItem, storageId));
        return storageItem;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (key == DATA_STORAGE_ITEM && this.m_9236_().m_5776_()) {
            this.entityStorageHolder.onStorageItemSynced();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasStorageItem()) {
            this.entityStorageHolder.tick((Entity)this);
        }
    }

    protected Component m_5677_() {
        if (this.hasStorageItem()) {
            return Component.m_237110_((String)StorageInMotionTranslationHelper.INSTANCE.translEntity("chested_horse_with_storage"), (Object[])new Object[]{super.m_5677_(), this.getStorageItem().m_41786_()});
        }
        return super.m_5677_();
    }
}

