/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.compat.recipeviewers.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.ClientRecipeHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.recipeviewers.common.subtypes.PropertyBasedSubtypeInterpreter;
import net.p3pp3rf1y.sophisticatedstorage.item.StorageBlockItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapedRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.crafting.MovingStorageTierUpgradeShapelessRecipe;
import net.p3pp3rf1y.sophisticatedstorageinmotion.item.MovingStorageItem;

public class MovingStorageTierUpgradeRecipesMaker {
    private MovingStorageTierUpgradeRecipesMaker() {
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<CraftingRecipe> getShapedCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return MovingStorageTierUpgradeRecipesMaker.getShapedCraftingRecipes(getSubtypeInterpreter, r -> r);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapedCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, Function<CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<MovingStorageTierUpgradeShapedRecipe> constructRecipe = (originalRecipe, ingredients, result) -> new ShapedRecipe(originalRecipe.m_6423_(), "", CraftingBookCategory.MISC, originalRecipe.m_44220_(), originalRecipe.m_44221_(), ingredients, result);
        return MovingStorageTierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, MovingStorageTierUpgradeShapedRecipe.class, getSubtypeInterpreter, transformRecipe);
    }

    public static <T extends PropertyBasedSubtypeInterpreter> List<CraftingRecipe> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter) {
        return MovingStorageTierUpgradeRecipesMaker.getShapelessCraftingRecipes(getSubtypeInterpreter, r -> r);
    }

    public static <R, T extends PropertyBasedSubtypeInterpreter> List<R> getShapelessCraftingRecipes(Function<ItemStack, Optional<T>> getSubtypeInterpreter, Function<CraftingRecipe, R> transformRecipe) {
        RecipeConstructor<MovingStorageTierUpgradeShapelessRecipe> constructRecipe = (originalRecipe, ingredients, result) -> new ShapelessRecipe(originalRecipe.m_6423_(), "", CraftingBookCategory.MISC, result, ingredients);
        return MovingStorageTierUpgradeRecipesMaker.getCraftingRecipes(constructRecipe, MovingStorageTierUpgradeShapelessRecipe.class, getSubtypeInterpreter, transformRecipe);
    }

    private static <R, T extends CraftingRecipe, U extends PropertyBasedSubtypeInterpreter> List<R> getCraftingRecipes(RecipeConstructor<T> constructRecipe, Class<T> originalRecipeClass, Function<ItemStack, Optional<U>> getSubtypeInterpreter, Function<CraftingRecipe, R> transformRecipe) {
        return ClientRecipeHelper.transformAllRecipesOfTypeIntoMultiple((RecipeType)RecipeType.f_44107_, originalRecipeClass, recipe -> {
            ArrayList itemGroupRecipes = new ArrayList();
            MovingStorageTierUpgradeRecipesMaker.getStorageItems(recipe).forEach(storageItem -> {
                NonNullList ingredients = recipe.m_7527_();
                TransientCraftingContainer craftinginventory = new TransientCraftingContainer(new AbstractContainerMenu(null, -1){

                    public ItemStack m_7648_(Player player, int index) {
                        return ItemStack.f_41583_;
                    }

                    public boolean m_6875_(Player playerIn) {
                        return false;
                    }
                }, 3, 3);
                NonNullList ingredientsCopy = NonNullList.m_182647_((int)ingredients.size());
                List<Object> baseMovingStorageItems = Collections.emptyList();
                int movingStorageIngredientIndex = -1;
                int i = 0;
                for (Ingredient ingredient : ingredients) {
                    Item patt4323$temp;
                    ItemStack[] ingredientItems = ingredient.m_43908_();
                    if (ingredientItems.length > 0 && (patt4323$temp = ingredientItems[0].m_41720_()) instanceof MovingStorageItem) {
                        MovingStorageItem movingStorageItem = (MovingStorageItem)patt4323$temp;
                        baseMovingStorageItems = movingStorageItem.getBaseMovingStorageItems();
                        movingStorageIngredientIndex = i;
                    } else if (!ingredient.m_43947_()) {
                        craftinginventory.m_6836_(i, ingredientItems[0]);
                    }
                    ingredientsCopy.add(i, (Object)ingredient);
                    ++i;
                }
                for (ItemStack movingStorage : baseMovingStorageItems) {
                    itemGroupRecipes.add(MovingStorageTierUpgradeRecipesMaker.createMovingStorageTierUpgradeRecipe(constructRecipe, recipe, storageItem, movingStorage, (NonNullList<Ingredient>)ingredientsCopy, movingStorageIngredientIndex, (CraftingContainer)craftinginventory, getSubtypeInterpreter, transformRecipe));
                }
            });
            return itemGroupRecipes;
        });
    }

    private static <R, T extends CraftingRecipe, U extends PropertyBasedSubtypeInterpreter> R createMovingStorageTierUpgradeRecipe(RecipeConstructor<T> constructRecipe, T recipe, ItemStack storageItem, ItemStack movingStorage, NonNullList<Ingredient> ingredients, int movingStorageIngredientIndex, CraftingContainer craftinginventory, Function<ItemStack, Optional<U>> getSubtypeInterpreter, Function<CraftingRecipe, R> transformRecipe) {
        MovingStorageItem.setStorageItem(movingStorage, storageItem);
        NonNullList ingredientsCopy = NonNullList.m_182647_((int)ingredients.size());
        ingredientsCopy.addAll(ingredients);
        ingredientsCopy.set(movingStorageIngredientIndex, (Object)Ingredient.m_43927_((ItemStack[])new ItemStack[]{movingStorage}));
        craftinginventory.m_6836_(movingStorageIngredientIndex, movingStorage.m_41777_());
        ItemStack result = ClientRecipeHelper.assemble(recipe, (Container)craftinginventory);
        ResourceLocation id = new ResourceLocation("sophisticatedstorageinmotion", "tier_upgrade_" + getSubtypeInterpreter.apply(storageItem).map(interpreter -> interpreter.getRegistrySanitizedItemString(storageItem)).orElse("") + "_to_" + getSubtypeInterpreter.apply(result).map(interpreter -> interpreter.getRegistrySanitizedItemString(result)).orElse(""));
        return transformRecipe.apply(constructRecipe.construct(recipe, (NonNullList<Ingredient>)ingredientsCopy, result));
    }

    private static List<ItemStack> getStorageItems(CraftingRecipe recipe) {
        NonNullList storageItems = NonNullList.m_122779_();
        for (Ingredient ingredient : recipe.m_7527_()) {
            ItemStack[] ingredientItems;
            for (ItemStack ingredientItem : ingredientItems = ingredient.m_43908_()) {
                Item item = ingredientItem.m_41720_();
                if (!(item instanceof MovingStorageItem) || !(MovingStorageItem.getStorageItem(ingredientItem).m_41720_() instanceof StorageBlockItem)) continue;
                storageItems.add((Object)MovingStorageItem.getStorageItem(ingredientItem));
            }
        }
        return storageItems;
    }

    private static interface RecipeConstructor<T extends Recipe<?>> {
        public CraftingRecipe construct(T var1, NonNullList<Ingredient> var2, ItemStack var3);
    }
}

