/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.p3pp3rf1y.sophisticatedcore.common.IItemActionPayloadHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedstorageinmotion.SophisticatedStorageInMotion;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.MovingStorageSyncItemHighlightsMessage;
import net.p3pp3rf1y.sophisticatedstorageinmotion.network.StorageInMotionPacketHandler;

public class MovingStorageItemActionPayloadHandler
implements IItemActionPayloadHandler<List<Integer>> {
    public static MovingStorageItemActionPayloadHandler INSTANCE = new MovingStorageItemActionPayloadHandler();
    public static final ResourceLocation ID = SophisticatedStorageInMotion.getRL("moving_storage_item_action");

    private MovingStorageItemActionPayloadHandler() {
    }

    public ResourceLocation id() {
        return ID;
    }

    public IItemActionPayloadHandler.HighlightResult computeHighlight(ServerPlayer player, ItemStackKey stackKey, List<Integer> clientData) {
        ArrayList<Integer> entitiesWithStack = new ArrayList<Integer>();
        ArrayList<Integer> entitiesWithItem = new ArrayList<Integer>();
        clientData.forEach(entityId -> {
            Entity entity = player.m_9236_().m_6815_(entityId.intValue());
            if (entity instanceof IMovingStorageEntity) {
                IMovingStorageEntity movingStorageEntity = (IMovingStorageEntity)entity;
                ISlotTracker slotTracker = movingStorageEntity.getStorageHolder().getStorageWrapper().getInventoryHandler().getSlotTracker();
                if (slotTracker.getPartialStacks().contains(stackKey) || slotTracker.getFullStacks().contains(stackKey)) {
                    entitiesWithStack.add((Integer)entityId);
                } else if (slotTracker.getItems().contains(stackKey.getStack().m_41720_())) {
                    entitiesWithItem.add((Integer)entityId);
                }
            }
        });
        StorageInMotionPacketHandler.INSTANCE.sendToClient(player, new MovingStorageSyncItemHighlightsMessage(entitiesWithStack, entitiesWithItem));
        return new IItemActionPayloadHandler.HighlightResult(entitiesWithStack.size(), entitiesWithItem.size());
    }

    public Map<Vec3, InventoryHandler> getTargetInventories(Player player, List<Integer> clientData) {
        return clientData.stream().map(entityId -> player.m_9236_().m_6815_(entityId.intValue())).filter(IMovingStorageEntity.class::isInstance).collect(Collectors.toMap(e -> e.m_20191_().m_82399_(), e -> ((IMovingStorageEntity)e).getStorageHolder().getStorageWrapper().getInventoryHandler()));
    }

    public List<Integer> decode(FriendlyByteBuf packetBuffer) {
        return (List)packetBuffer.m_236838_(ArrayList::new, FriendlyByteBuf::readInt);
    }

    public void encode(FriendlyByteBuf packetBuffer, List<Integer> value) {
        packetBuffer.m_236828_(value, FriendlyByteBuf::writeInt);
    }
}

