/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorageinmotion.client.gui;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.p3pp3rf1y.sophisticatedcore.util.ITintable;
import net.p3pp3rf1y.sophisticatedcore.util.InventoryHelper;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.item.PaintbrushItem;
import net.p3pp3rf1y.sophisticatedstorageinmotion.entity.IMovingStorageEntity;

public class PaintbrushMovingStorageOverlay {
    private static Optional<PaintbrushItem.ItemRequirements> ITEM_REQUIREMENTS_CACHE = Optional.empty();
    private static int lastEntityIdCached = -1;
    @Nullable
    private static ItemStack lastPaintbrushCached = null;
    public static final IGuiOverlay HUD_PAINTBRUSH_INFO = (gui, guiGraphics, partialTicks, width, height) -> {
        EntityHitResult entityHitResult;
        HitResult patt3369$temp;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91080_ != null) {
            if (!mc.f_91080_.m_7043_()) {
                lastEntityIdCached = -1;
                lastPaintbrushCached = null;
            }
            return;
        }
        LocalPlayer player = mc.f_91074_;
        ClientLevel level = mc.f_91073_;
        if (player == null || level == null || !((patt3369$temp = mc.f_91077_) instanceof EntityHitResult) || !((entityHitResult = (EntityHitResult)patt3369$temp).m_82443_() instanceof IMovingStorageEntity)) {
            return;
        }
        InventoryHelper.getItemFromEitherHand((Player)player, (Item)((Item)ModItems.PAINTBRUSH.get())).flatMap(paintbrush -> PaintbrushMovingStorageOverlay.getItemRequirementsFor(paintbrush, (Player)player, entityHitResult.m_82443_())).ifPresent(itemRequirements -> {
            if (itemRequirements.itemsMissing().isEmpty()) {
                return;
            }
            Component missingItems = StorageTranslationHelper.INSTANCE.translItemOverlayMessage((Item)ModItems.PAINTBRUSH.get(), "missing_items", new Object[0]);
            Font font = mc.f_91062_;
            int i = font.m_92852_((FormattedText)missingItems);
            int x = (gui.f_92977_ - i) / 2;
            int y = gui.f_92978_ - 75 - 10;
            guiGraphics.m_280430_(font, missingItems, x + 1, y, DyeColor.WHITE.m_41071_());
            x = (gui.f_92977_ - itemRequirements.itemsMissing().size() * 18) / 2;
            for (ItemStack missingItem : itemRequirements.itemsMissing()) {
                guiGraphics.m_280480_(missingItem, x, y + 10);
                guiGraphics.m_280370_(font, missingItem, x, y + 10);
                x += 18;
            }
        });
    };

    public static <T extends Entity> Optional<PaintbrushItem.ItemRequirements> getItemRequirementsFor(ItemStack paintbrush, Player player, Entity entity) {
        if (!(entity instanceof IMovingStorageEntity)) {
            return Optional.empty();
        }
        Entity movingStorage = entity;
        if (movingStorage.m_19879_() != lastEntityIdCached || paintbrush != lastPaintbrushCached) {
            ITEM_REQUIREMENTS_CACHE = PaintbrushMovingStorageOverlay.getItemRequirements(paintbrush, player, movingStorage);
            lastEntityIdCached = movingStorage.m_19879_();
            lastPaintbrushCached = paintbrush;
        }
        return ITEM_REQUIREMENTS_CACHE;
    }

    private static <T extends Entity> Optional<PaintbrushItem.ItemRequirements> getItemRequirements(ItemStack paintbrush, Player player, T movingStorage) {
        HashMap materialsToApply = new HashMap(PaintbrushItem.getBarrelMaterials((ItemStack)paintbrush));
        if (!materialsToApply.isEmpty()) {
            if (!((IMovingStorageEntity)movingStorage).getStorageHolder().canHoldMaterials()) {
                return Optional.empty();
            }
            return PaintbrushItem.getItemRequirements((ItemStack)paintbrush, (Player)player, (Map)PaintbrushItem.getMaterialHolderPartsNeeded(materialsToApply, ((IMovingStorageEntity)movingStorage).getStorageHolder()));
        }
        int mainColorToSet = PaintbrushItem.getMainColor((ItemStack)paintbrush);
        int accentColorToSet = PaintbrushItem.getAccentColor((ItemStack)paintbrush);
        return PaintbrushItem.getDyeItemRequirements((ItemStack)paintbrush, (Player)player, (Map)PaintbrushItem.getStorageDyePartsNeeded((int)mainColorToSet, (int)accentColorToSet, (ITintable)((IMovingStorageEntity)movingStorage).getStorageHolder().getStorageWrapper()));
    }
}

