/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.render.immediate.buffer_builder.sorting;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BufferBuilder.class})
public abstract class BufferBuilderMixin {
    @Shadow
    private ByteBuffer f_85648_;
    @Shadow
    private int f_85652_;
    @Shadow
    @Nullable
    private Vector3f[] f_166766_;
    @Shadow
    private int f_85654_;
    @Shadow
    private VertexFormat f_85658_;
    @Shadow
    private int f_231157_;
    @Shadow
    @Nullable
    private VertexSorting f_276463_;
    @Unique
    private static final int[] VERTEX_ORDER = new int[]{0, 1, 2, 2, 3, 0};

    @Overwrite
    private Vector3f[] m_166794_() {
        int vertexStride = this.f_85658_.m_86020_();
        int primitiveCount = this.f_85654_ / 4;
        Vector3f[] centers = new Vector3f[primitiveCount];
        for (int index = 0; index < primitiveCount; ++index) {
            long v1 = MemoryUtil.memAddress((ByteBuffer)this.f_85648_, (int)(this.f_231157_ + (index * 4 + 0) * vertexStride));
            long v2 = MemoryUtil.memAddress((ByteBuffer)this.f_85648_, (int)(this.f_231157_ + (index * 4 + 2) * vertexStride));
            float x1 = MemoryUtil.memGetFloat((long)(v1 + 0L));
            float y1 = MemoryUtil.memGetFloat((long)(v1 + 4L));
            float z1 = MemoryUtil.memGetFloat((long)(v1 + 8L));
            float x2 = MemoryUtil.memGetFloat((long)(v2 + 0L));
            float y2 = MemoryUtil.memGetFloat((long)(v2 + 4L));
            float z2 = MemoryUtil.memGetFloat((long)(v2 + 8L));
            centers[index] = new Vector3f((x1 + x2) * 0.5f, (y1 + y2) * 0.5f, (z1 + z2) * 0.5f);
        }
        return centers;
    }

    @Overwrite
    private void m_166786_(VertexFormat.IndexType indexType) {
        if (this.f_276463_ != null) {
            int[] indices = this.f_276463_.m_277065_(this.f_166766_);
            this.writePrimitiveIndices(indexType, indices);
        }
    }

    @Unique
    private void writePrimitiveIndices(VertexFormat.IndexType indexType, int[] indices) {
        long ptr = MemoryUtil.memAddress((ByteBuffer)this.f_85648_, (int)this.f_85652_);
        switch (indexType.f_166924_) {
            case 2: {
                for (int index : indices) {
                    int start = index * 4;
                    for (int offset : VERTEX_ORDER) {
                        MemoryUtil.memPutShort((long)ptr, (short)((short)(start + offset)));
                        ptr += 2L;
                    }
                }
                break;
            }
            case 4: {
                for (int index : indices) {
                    int start = index * 4;
                    for (int offset : VERTEX_ORDER) {
                        MemoryUtil.memPutInt((long)ptr, (int)(start + offset));
                        ptr += 4L;
                    }
                }
                break;
            }
        }
    }
}

