/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.compability;

import com.mojang.blaze3d.systems.RenderSystem;
import net.irisshaders.iris.Iris;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.fml.ModList;
import org.joml.Matrix4fc;
import team.lodestar.lodestone.handlers.RenderHandler;

public class OculusCompat {
    public static boolean LOADED;

    public static void init() {
        LOADED = ModList.get().isLoaded("oculus");
    }

    public static boolean isLoaded() {
        return LOADED;
    }

    public static boolean isShadersEnabled() {
        if (OculusCompat.isLoaded()) {
            return LoadedOnly.isShadersEnabled();
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderStages(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_LEVEL)) {
            RenderSystem.getModelViewStack().m_85836_();
            RenderSystem.getModelViewStack().m_166856_();
            if (RenderHandler.MATRIX4F != null) {
                RenderSystem.getModelViewMatrix().set((Matrix4fc)RenderHandler.MATRIX4F);
            }
            OculusCompat.endBatchesParticles();
            RenderSystem.getModelViewStack().m_85849_();
            RenderSystem.applyModelViewMatrix();
            OculusCompat.endBatches();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void endBatchesParticles() {
        RenderHandler.copyDepthBuffer(RenderHandler.LODESTONE_DEPTH_CACHE);
        OculusCompat.endBatchesParticles(RenderHandler.DELAYED_RENDER);
        OculusCompat.endBatchesParticles(RenderHandler.LATE_DELAYED_RENDER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void endBatches() {
        RenderHandler.copyDepthBuffer(RenderHandler.LODESTONE_DEPTH_CACHE);
        OculusCompat.endBatches(RenderHandler.DELAYED_RENDER);
        OculusCompat.endBatches(RenderHandler.LATE_DELAYED_RENDER);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void endBatchesParticles(RenderHandler.LodestoneRenderLayer renderLayer) {
        RenderHandler.beginBufferedRendering();
        RenderHandler.renderBufferedParticles(renderLayer, true);
        RenderHandler.renderBufferedParticles(renderLayer, false);
        RenderHandler.endBufferedRendering();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void endBatches(RenderHandler.LodestoneRenderLayer renderLayer) {
        RenderHandler.beginBufferedRendering();
        RenderHandler.renderBufferedBatches(renderLayer, true);
        RenderHandler.renderBufferedBatches(renderLayer, false);
        RenderHandler.endBufferedRendering();
    }

    public static class LoadedOnly {
        public static boolean isShadersEnabled() {
            return Iris.getIrisConfig().areShadersEnabled();
        }
    }
}

