/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.networking.carbon;

import carbonconfiglib.CarbonConfig;
import carbonconfiglib.impl.internal.EventHandler;
import carbonconfiglib.networking.ICarbonPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;

public class StateSyncPacket
implements ICarbonPacket {
    Dist source;

    public StateSyncPacket() {
    }

    public StateSyncPacket(Dist source) {
        this.source = source;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.source.isClient());
    }

    @Override
    public void read(FriendlyByteBuf buffer) {
        this.source = buffer.readBoolean() ? Dist.CLIENT : Dist.DEDICATED_SERVER;
    }

    @Override
    public void process(Player player) {
        if (this.source.isDedicatedServer()) {
            CarbonConfig.NETWORK.onPlayerJoined(player, false);
        } else {
            EventHandler.INSTANCE.onServerJoinPacket(player);
        }
    }
}

