/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.config;

import carbonconfiglib.gui.api.EntrySettingTypes;
import carbonconfiglib.gui.api.IArrayNode;
import carbonconfiglib.gui.api.ICompoundNode;
import carbonconfiglib.gui.api.INode;
import carbonconfiglib.gui.api.IValueNode;
import carbonconfiglib.gui.config.Element;
import carbonconfiglib.gui.screen.ListSelectionScreen;
import carbonconfiglib.gui.widgets.CarbonHoverIconButton;
import carbonconfiglib.gui.widgets.CarbonIconButton;
import carbonconfiglib.gui.widgets.GuiUtils;
import carbonconfiglib.gui.widgets.IOwnable;
import carbonconfiglib.gui.widgets.Icon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigElement
extends Element {
    private static final Component DELETE = Component.m_237115_((String)"gui.carbonconfig.delete");
    private static final Component REVERT = Component.m_237115_((String)"gui.carbonconfig.revert");
    private static final Component DEFAULT = Component.m_237115_((String)"gui.carbonconfig.default");
    private static final Component SUGGESTIONS = Component.m_237115_((String)"gui.carbonconfig.suggestions");
    private static final Component RELOAD = Component.m_237115_((String)"gui.carbonconfig.reload").m_130940_(ChatFormatting.YELLOW);
    private static final Component RESTART = Component.m_237115_((String)"gui.carbonconfig.restart").m_130940_(ChatFormatting.YELLOW);
    protected List<GuiEventListener> listeners = new ObjectArrayList();
    protected List<Map.Entry<AbstractWidget, AlignOffset>> mappedListeners = new ObjectArrayList();
    protected IValueNode value;
    protected IArrayNode array;
    protected ICompoundNode compound;
    protected CarbonIconButton setReset;
    protected CarbonIconButton setDefault;
    protected CarbonIconButton suggestion;
    protected CarbonHoverIconButton moveDown;
    protected CarbonHoverIconButton moveUp;

    protected ConfigElement(Component name) {
        super(name);
    }

    public ConfigElement(IValueNode value) {
        super(value.getName());
        this.value = value;
    }

    public ConfigElement(IArrayNode array, IValueNode value) {
        super(value.getName());
        this.array = array;
        this.value = value;
    }

    public ConfigElement(IArrayNode array, Component name) {
        super(name);
        this.array = array;
    }

    public ConfigElement(ICompoundNode compound, Component name) {
        super(name);
        this.compound = compound;
    }

    public ConfigElement(ICompoundNode compound, IValueNode value) {
        super(value.getName());
        this.compound = compound;
        this.value = value;
    }

    protected static Component create(IArrayNode array, INode node) {
        if (array == null) {
            return null;
        }
        EntrySettingTypes.ArrayRenamer settings = array.getSetting(EntrySettingTypes.ArrayRenamer.class);
        return settings == null ? null : Component.m_237115_((String)settings.getFunction().apply(array.indexOf(node), node));
    }

    protected <T extends AbstractWidget> T addChild(T element) {
        return this.addChild(element, GuiAlign.RIGHT, 0);
    }

    protected <T extends AbstractWidget> T addChild(T element, int xOffset) {
        return this.addChild(element, GuiAlign.RIGHT, xOffset);
    }

    protected <T extends AbstractWidget> T addChild(T element, GuiAlign align, int xOffset) {
        this.listeners.add((GuiEventListener)element);
        this.mappedListeners.add(new AbstractMap.SimpleEntry<T, AlignOffset>(element, new AlignOffset(align, -xOffset - 19)));
        if (this.owner != null && element instanceof IOwnable) {
            ((IOwnable)element).setOwner(this.owner);
        }
        return element;
    }

    @Override
    public void init() {
        super.init();
        if (this.createResetButtons(this.value)) {
            if (this.isArray()) {
                this.setReset = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.DELETE, (Component)Component.m_237119_(), this::onDeleted).setIconOnly(), -51);
                this.setReset.f_93623_ = this.isReset();
                this.moveDown = new CarbonHoverIconButton(0, 0, 15, 8, new CarbonHoverIconButton.IconInfo(0, -3, 16, 16), Icon.MOVE_DOWN, Icon.MOVE_DOWN_HOVERED, this::onMoveDown);
                this.listeners.add((GuiEventListener)this.moveDown);
                this.moveUp = new CarbonHoverIconButton(0, 0, 15, 8, new CarbonHoverIconButton.IconInfo(0, -3, 16, 16), Icon.MOVE_UP, Icon.MOVE_UP_HOVERED, this::onMoveUp);
                this.listeners.add((GuiEventListener)this.moveUp);
            } else {
                this.setReset = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.REVERT, (Component)Component.m_237119_(), this::onReset).setIconOnly(), -21);
                this.setDefault = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.SET_DEFAULT, (Component)Component.m_237119_(), this::onDefault).setIconOnly(), -40);
                this.suggestion = this.addChild(new CarbonIconButton(0, 0, 18, 18, Icon.SUGGESTIONS, (Component)Component.m_237119_(), this::onSuggestion).setIconOnly(), -59);
                this.setReset.f_93623_ = this.isReset();
                this.setDefault.f_93623_ = !this.isDefault();
                this.suggestion.f_93624_ = false;
            }
        }
        if (this.owner != null) {
            for (GuiEventListener entry : this.listeners) {
                if (!(entry instanceof IOwnable)) continue;
                ((IOwnable)entry).setOwner(this.owner);
            }
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.setReset != null) {
            this.setReset.f_93623_ = this.isReset();
        }
        if (this.setDefault != null) {
            this.setDefault.f_93623_ = !this.isDefault();
        }
    }

    @Override
    public void m_6311_(GuiGraphics graphics, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
        if (this.renderName() && !this.isArray()) {
            this.renderName(graphics, left, top, this.isChanged(), this.isCompound() ? 80 : 200, height);
            if (!this.isCompound() && this.value != null) {
                if (this.value.requiresReload()) {
                    GuiUtils.drawTextureRegion(graphics, left - 16, top + height / 2 - 6, 12.0f, 12.0f, Icon.RELOAD, 16.0f, 16.0f);
                    if (mouseX >= left - 16 && mouseX <= left - 4 && mouseY >= top && mouseY <= top + height && this.owner.isInsideList(mouseX, mouseY)) {
                        this.owner.addTooltips(RELOAD);
                    }
                }
                if (this.value.requiresRestart()) {
                    GuiUtils.drawTextureRegion(graphics, left - 16, top + height / 2 - 6, 12.0f, 12.0f, Icon.RESTART, 16.0f, 16.0f);
                    if (mouseX >= left - 16 && mouseX <= left - 4 && mouseY >= top && mouseY <= top + height && this.owner.isInsideList(mouseX, mouseY)) {
                        this.owner.addTooltips(RESTART);
                    }
                }
            }
        }
        int maxX = Integer.MAX_VALUE;
        if (this.renderChildren()) {
            if (this.isArray()) {
                this.moveUp.m_252865_(left + width - 16);
                this.moveUp.m_253211_(top);
                this.moveUp.f_93624_ = this.canMoveUp();
                this.moveUp.m_88315_(graphics, mouseX, mouseY, partialTicks);
                this.moveDown.m_252865_(left + width - 16);
                this.moveDown.m_253211_(top + 10);
                this.moveDown.f_93624_ = this.canMoveDown();
                this.moveDown.m_88315_(graphics, mouseX, mouseY, partialTicks);
                if (this.moveDown.f_93624_ || this.moveUp.f_93624_) {
                    left -= 8;
                }
            }
            for (Map.Entry<AbstractWidget, AlignOffset> entry : this.mappedListeners) {
                AbstractWidget widget = entry.getKey();
                AlignOffset offset = entry.getValue();
                widget.m_252865_(offset.align.align(left, width, widget.m_5711_()) + offset.offset);
                widget.m_253211_(top);
                widget.m_88315_(graphics, mouseX, mouseY, partialTicks);
                maxX = Math.min(maxX, widget.m_252754_());
            }
        }
        maxX = this.getMaxX(maxX);
        if (this.isArray()) {
            MutableComponent comp = Component.m_237113_((String)(this.indexOf() + ":"));
            this.renderText(graphics, (Component)comp, maxX - 115, top - 1, 105.0f, height, GuiAlign.RIGHT, -1);
        }
        if (this.value != null && mouseY >= top && mouseY <= top + height && mouseX >= left && mouseX <= maxX - 2 && this.owner.isInsideList(mouseX, mouseY)) {
            this.owner.addTooltips(this.value.getTooltip());
        }
        if (this.isArray()) {
            if (this.setReset.m_198029_() && this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(DELETE);
            }
        } else {
            if (this.setReset.m_198029_() && this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(REVERT);
            }
            if (this.setDefault.m_198029_() && this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(DEFAULT);
            }
            this.suggestion.f_93624_ = this.hasSuggestions();
            if (this.suggestion.f_93624_ && this.suggestion.m_198029_() & this.owner.isInsideList(mouseX, mouseY)) {
                this.owner.addTooltips(SUGGESTIONS);
            }
        }
    }

    protected boolean hasSuggestions() {
        return this.value != null && this.value.getSuggestions().size() > 0;
    }

    protected int getMaxX(int prevMaxX) {
        return prevMaxX;
    }

    protected int getMaxTextWidth() {
        return this.isCompound() ? 190 : 200;
    }

    protected boolean isArray() {
        return this.array != null;
    }

    protected boolean isCompound() {
        return this.compound != null;
    }

    protected void onMoveDown(CarbonHoverIconButton button) {
        if (!this.isArray()) {
            return;
        }
        this.array.moveDown(this.indexOf());
        this.owner.updateInformation();
    }

    protected void onMoveUp(CarbonHoverIconButton button) {
        if (!this.isArray()) {
            return;
        }
        this.array.moveUp(this.indexOf());
        this.owner.updateInformation();
    }

    protected boolean canMove() {
        return this.isArray() && (this.canMoveDown() || this.canMoveUp());
    }

    protected boolean canMoveUp() {
        return this.indexOf() > 0;
    }

    protected boolean canMoveDown() {
        return this.indexOf() < this.array.size() - 1;
    }

    protected boolean renderName() {
        return true;
    }

    protected boolean renderChildren() {
        return true;
    }

    protected boolean requiresRestart() {
        return this.value != null && this.value.requiresRestart();
    }

    protected boolean requiresReload() {
        return this.value != null && this.value.requiresReload();
    }

    protected Component tooltip() {
        return this.value == null ? null : this.value.getTooltip();
    }

    protected boolean createResetButtons(IValueNode value) {
        return value != null;
    }

    protected int indexOf() {
        return this.array.indexOf(this.value);
    }

    protected boolean isReset() {
        return this.isArray() || this.value.isChanged();
    }

    @Override
    public boolean isChanged() {
        return this.value.isChanged();
    }

    @Override
    public boolean isDefault() {
        return this.value.isDefault();
    }

    protected void onDeleted(CarbonIconButton button) {
        if (!this.isArray()) {
            return;
        }
        this.owner.removeEntry(this);
    }

    protected void onReset(CarbonIconButton button) {
        this.value.setPrevious();
        this.updateValues();
    }

    protected void onDefault(CarbonIconButton button) {
        if (this.value == null) {
            return;
        }
        this.value.setDefault();
        this.updateValues();
    }

    protected void onSuggestion(CarbonIconButton button) {
        if (this.value == null) {
            return;
        }
        this.mc.m_91152_((Screen)new ListSelectionScreen(this.mc.f_91080_, this.value, ListSelectionScreen.NodeSupplier.ofValue(), this.owner.getCustomTexture()));
    }

    @Override
    public void updateValues() {
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return this.listeners;
    }

    public static enum GuiAlign {
        LEFT,
        CENTER,
        RIGHT;


        public int align(int left, int bounds, int width) {
            switch (this) {
                case LEFT: {
                    return left;
                }
                case CENTER: {
                    return left + bounds / 2 - width / 2;
                }
                case RIGHT: {
                    return left + bounds - width - 42;
                }
            }
            return left;
        }

        public float align(float width) {
            switch (this) {
                case CENTER: {
                    return width * -0.5f;
                }
                case RIGHT: {
                    return -width;
                }
            }
            return 0.0f;
        }

        public float alignCenter() {
            switch (this) {
                case CENTER: {
                    return 0.0f;
                }
                case RIGHT: {
                    return 0.5f;
                }
            }
            return -0.5f;
        }
    }

    public static class AlignOffset {
        GuiAlign align;
        int offset;

        public AlignOffset(GuiAlign align, int offset) {
            this.align = align;
            this.offset = offset;
        }
    }
}

