/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.datagen;

import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.core.register.SMBlocks;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.util.AnnotationHelper;
import fathertoast.specialmobs.common.util.References;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.RegistryObject;

public class SMLanguageProvider
extends LanguageProvider {
    private static final String[][] TRANSLATIONS;
    public static final HashMap<String, TranslationKey> LANG_CODE_MAP;
    private final TranslationKey translationKey;

    private static String[] format(String[] formats, String[] args) {
        String[] formatted = new String[formats.length];
        for (int i = 0; i < formatted.length; ++i) {
            formatted[i] = String.format(formats[i], args[i]);
        }
        return formatted;
    }

    private static void mapAll(TranslationKey translation, String ... locales) {
        for (String locale : locales) {
            LANG_CODE_MAP.put(translation.code + "_" + locale, translation);
        }
    }

    public SMLanguageProvider(PackOutput output, String locale, TranslationKey translateKey) {
        super(output, "specialmobs", locale);
        this.translationKey = translateKey;
    }

    protected void addTranslations() {
        int k = this.translationKey.ordinal() + 1;
        for (String[] translationArray : TRANSLATIONS) {
            if (translationArray[k] == null || translationArray[k].isEmpty()) continue;
            this.add(translationArray[0], translationArray[k]);
        }
        this.add("itemGroup.magical_relics.spawn_eggs", "Special Mobs - Spawn Eggs");
        this.add("config.jade.plugin_specialmobs.display_ninja_disguises", "Display Ninja Disguises");
    }

    static {
        LANG_CODE_MAP = new HashMap();
        ArrayList<String[]> translationList = new ArrayList<String[]>();
        String[] spawnEggTranslationPattern = References.translations("%s", "%s Spawn Egg", "Generar %s", "Ovo de invoca\u00e7\u00e3o de %s", "Oeuf d'apparition de %s", "Uovo generatore di %s", "%s-Spawn-Ei", "%s Cackle Fruit");
        String[] vanillaReplacementSpawnEggTranslationPattern = References.translations("%s", "Normal %s Spawn Egg", "Generar %s normal", "Ovo de invoca\u00e7\u00e3o de %s normal", "Oeuf d'apparition de %s normale", "Uovo generatore di %s normale", "Normale-%s-Spawn-Ei", "Simple %s Cackle Fruit");
        for (MobFamily.Species<?> species : MobFamily.getAllSpecies()) {
            String[] speciesTranslations = AnnotationHelper.getTranslations(species);
            String[] stringArray = SMLanguageProvider.format(species.specialVariantName == null ? vanillaReplacementSpawnEggTranslationPattern : spawnEggTranslationPattern, speciesTranslations);
            stringArray[0] = ((ForgeSpawnEggItem)species.spawnEgg.get()).m_5524_();
            translationList.add(speciesTranslations);
            translationList.add(stringArray);
        }
        translationList.add(References.translations(((EntityType)SMEntities.BONE_SHRAPNEL.get()).m_20675_(), "Bone Shrapnel", "Metralla de hueso", "Estilha\u00e7os de osso", "Tesson d'os", "Schegge di osso", "Knochensplitter", ""));
        translationList.add(References.translations(((EntityType)SMEntities.BUG_SPIT.get()).m_20675_(), "Bug Spit", "Escupir bicho", "Cuspe de inseto", "Cracher des insectes", "Sputo di insetti", "K\u00e4ferspucken", ""));
        translationList.add(References.translations(((EntityType)SMEntities.INCORPOREAL_FIREBALL.get()).m_20675_(), "Incorporeal Fireball", "Bola de fuego incorp\u00f3rea", "Bola de fogo incorp\u00f3rea", "Boule de feu incorporelle", "Palla di fuoco incorporea", "Unk\u00f6rperlicher Feuerkugel", "Haunted Cannonball"));
        translationList.add(References.translations(((EntityType)SMEntities.SLAB_FIREBALL.get()).m_20675_(), "Slab Fireball", "", "", "", "", "", ""));
        translationList.add(References.translations(((EntityType)SMEntities.FISHING_BOBBER.get()).m_20675_(), "Fishing Bobber", "Anzuelo", "Boia de pesca", "Flotteur", "Galleggiante da pesca", "Schwimmer", "Fishin' Bobber"));
        translationList.add(References.translations(((EntityType)SMEntities.MOB_BOAT.get()).m_20675_(), "Boat", "", "", "", "", "", ""));
        for (RegistryObject regObject : SMBlocks.REGISTRY.getEntries()) {
            translationList.add(AnnotationHelper.getTranslations((Block)regObject.get()));
        }
        for (RegistryObject regObject : SMItems.REGISTRY.getEntries()) {
            if (regObject.get() instanceof ForgeSpawnEggItem || regObject.get() instanceof BlockItem) continue;
            translationList.add(AnnotationHelper.getTranslations((Item)regObject.get()));
        }
        TRANSLATIONS = (String[][])translationList.toArray((T[])new String[0][0]);
        SMLanguageProvider.mapAll(TranslationKey.ENGLISH, "us");
        SMLanguageProvider.mapAll(TranslationKey.SPANISH, "ar", "cl", "ec", "mx", "uy", "ve");
        SMLanguageProvider.mapAll(TranslationKey.PORTUGUESE, "pt", "br");
        SMLanguageProvider.mapAll(TranslationKey.FRENCH, "fr", "ca");
        SMLanguageProvider.mapAll(TranslationKey.ITALIAN, "it");
        SMLanguageProvider.mapAll(TranslationKey.GERMAN, "de", "at", "ch");
        SMLanguageProvider.mapAll(TranslationKey.PIRATE, "pt");
        SpecialMobs.LOG.info("Starting translation key verification...");
        for (Iterator<MobFamily.Species<Object>> iterator : TranslationKey.values()) {
            if (!LANG_CODE_MAP.containsValue(iterator)) {
                SpecialMobs.LOG.error("Translation key {} has no lang codes assigned!", (Object)((Enum)((Object)iterator)).name());
            }
            int k = ((Enum)((Object)iterator)).ordinal() + 1;
            boolean missedAny = false;
            for (String[] translationArray : TRANSLATIONS) {
                if (translationArray[k] != null && !translationArray[k].isEmpty()) continue;
                SpecialMobs.LOG.error("Translation key {} is missing a translation for lang key \"{}\"!", (Object)((Enum)((Object)iterator)).name(), (Object)translationArray[0]);
                missedAny = true;
            }
            if (!missedAny || iterator != TranslationKey.ENGLISH) continue;
            throw new IllegalStateException("Come on, man!");
        }
        SpecialMobs.LOG.info("Translation key verification complete!");
    }

    public static enum TranslationKey {
        ENGLISH("en"),
        SPANISH("es"),
        PORTUGUESE("pt"),
        FRENCH("fr"),
        ITALIAN("it"),
        GERMAN("de"),
        PIRATE("en");

        public final String code;

        private TranslationKey(String id) {
            this.code = id;
        }
    }
}

