/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.event;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="specialmobs")
public class PlayerVelocityWatcher {
    private static final HashMap<UUID, Entry> TRACKER = new HashMap();
    private static int cleanupCounter;

    public static Entry get(Player player) {
        Entry trackerEntry = TRACKER.get(player.m_20148_());
        if (trackerEntry == null) {
            trackerEntry = new Entry(player.m_20182_());
            TRACKER.put(player.m_20148_(), trackerEntry);
        }
        return trackerEntry;
    }

    public static Vec3 getVelocity(Entity entity) {
        Vec3 vec3;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            vec3 = PlayerVelocityWatcher.get(player).velocity();
        } else {
            vec3 = entity.m_20184_();
        }
        return vec3;
    }

    @SubscribeEvent
    protected static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            Entry trackerEntry = PlayerVelocityWatcher.get(event.player);
            trackerEntry.update(event.player.m_20182_());
        }
    }

    @SubscribeEvent
    protected static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++cleanupCounter >= 69420) {
            cleanupCounter = 0;
            PlayerList onlinePlayers = ServerLifecycleHooks.getCurrentServer().m_6846_();
            TRACKER.keySet().removeIf(uuid -> onlinePlayers.m_11259_(uuid) == null);
        }
    }

    @SubscribeEvent
    protected static void onServerStopping(ServerStoppingEvent event) {
        cleanupCounter = 0;
        TRACKER.clear();
    }

    public static class Entry {
        public double xPrev;
        public double yPrev;
        public double zPrev;
        public double x;
        public double y;
        public double z;

        private Entry(Vec3 pos) {
            this.reset(pos);
        }

        public double dX() {
            return this.x - this.xPrev;
        }

        public double dY() {
            return this.y - this.yPrev;
        }

        public double dZ() {
            return this.z - this.zPrev;
        }

        public Vec3 velocity() {
            return new Vec3(this.dX(), this.dY(), this.dZ());
        }

        public boolean isMoving() {
            return Math.abs(this.dX()) > 1.0E-4 || Math.abs(this.dZ()) > 1.0E-4 || Math.abs(this.dY()) > 1.0E-4;
        }

        public void reset(Vec3 pos) {
            this.xPrev = this.x = pos.f_82479_;
            this.yPrev = this.y = pos.f_82480_;
            this.zPrev = this.z = pos.f_82481_;
        }

        private void update(Vec3 pos) {
            this.xPrev = this.x;
            this.yPrev = this.y;
            this.zPrev = this.z;
            this.x = pos.f_82479_;
            this.y = pos.f_82480_;
            this.z = pos.f_82481_;
        }
    }
}

