/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.event;

import fathertoast.crust.api.event.AdvancementLoadEvent;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class AdvancementFixer {
    private static final ResourceLocation KILL_A_MOB_ADV = new ResourceLocation("adventure/kill_a_mob");
    private static final ResourceLocation KILL_ALL_MOBS_ADV = new ResourceLocation("adventure/kill_all_mobs");
    private static final ResourceLocation SNIPER_DUEL_ADV = new ResourceLocation("adventure/sniper_duel");
    private static final ResourceLocation RETURN_TO_SENDER_ADV = new ResourceLocation("nether/return_to_sender");
    private static final ResourceLocation UNEASY_ALLIANCE_ADV = new ResourceLocation("nether/uneasy_alliance");
    private ServerAdvancementManager manager;

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        this.manager = event.getServer().m_129889_();
    }

    @SubscribeEvent
    public void onAdvancementLoad(AdvancementLoadEvent event) {
        ResourceLocation id = event.getId();
        if (id.equals((Object)KILL_A_MOB_ADV)) {
            for (MobFamily.Species<?> species : MobFamily.getAllSpecies()) {
                EntityType entityType = (EntityType)species.entityType.get();
                String entityId = species.entityType.getId().toString();
                event.getBuilder().m_138386_(entityId, (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(entityType)));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        DamageSource source = event.getSource();
        if (!livingEntity.m_9236_().f_46443_ && (entity = source.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (livingEntity instanceof ISpecialMob) {
                Advancement uneasyAlliance;
                Advancement returnToSender;
                Advancement sniperDuel;
                Advancement killAllMob;
                Advancement killAMob = this.getFromId(KILL_A_MOB_ADV);
                if (this.notCompleted(player, killAMob)) {
                    this.maybeGrantKillAMob((LivingEntity)((ISpecialMob)livingEntity), player, source, killAMob);
                }
                if (this.notCompleted(player, killAllMob = this.getFromId(KILL_ALL_MOBS_ADV))) {
                    this.maybeGrantKillAllMobs((LivingEntity)((ISpecialMob)livingEntity), player, source, killAllMob);
                }
                if (this.notCompleted(player, sniperDuel = this.getFromId(SNIPER_DUEL_ADV))) {
                    this.maybeGrantSniperDuel((LivingEntity)((ISpecialMob)livingEntity), player, source, sniperDuel);
                }
                if (this.notCompleted(player, returnToSender = this.getFromId(RETURN_TO_SENDER_ADV))) {
                    this.maybeGrantReturnToSender((LivingEntity)((ISpecialMob)livingEntity), player, source, returnToSender);
                }
                if (this.notCompleted(player, uneasyAlliance = this.getFromId(UNEASY_ALLIANCE_ADV))) {
                    AdvancementFixer.maybeGrantUneasyAlliance((LivingEntity)((ISpecialMob)livingEntity), player, source, uneasyAlliance);
                }
            }
        }
    }

    private <T extends LivingEntity> void maybeGrantKillAMob(T dead, ServerPlayer player, DamageSource damageSource, Advancement advancement) {
        if (damageSource.m_7639_() instanceof Player && !dead.m_9236_().f_46443_) {
            player.m_8960_().m_135988_(advancement, "minecraft:creeper");
        }
    }

    private <T extends LivingEntity> void maybeGrantKillAllMobs(T dead, ServerPlayer player, DamageSource damageSource, Advancement advancement) {
        if (damageSource.m_7639_() instanceof Player && !dead.m_9236_().f_46443_) {
            for (EntityType<?> type : ((ISpecialMob)dead).getSpecies().family.replaceableTypes) {
                player.m_8960_().m_135988_(advancement, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(type)).toString());
            }
        }
    }

    private <T extends LivingEntity> void maybeGrantSniperDuel(T dead, ServerPlayer player, DamageSource damageSource, Advancement advancement) {
        float z;
        float x;
        float dist;
        if (dead instanceof _SpecialSkeletonEntity && damageSource.m_7640_() instanceof Projectile && (dist = Mth.m_14116_((float)((x = (float)(dead.m_20185_() - player.m_20185_())) * x + (z = (float)(dead.m_20189_() - player.m_20189_())) * z))) >= 50.0f) {
            player.m_8960_().m_135988_(advancement, "killed_skeleton");
        }
    }

    private <T extends LivingEntity> void maybeGrantReturnToSender(T dead, ServerPlayer player, DamageSource damageSource, Advancement advancement) {
        if (dead instanceof _SpecialGhastEntity && damageSource.m_7640_() instanceof AbstractHurtingProjectile) {
            player.m_8960_().m_135988_(advancement, "killed_ghast");
        }
    }

    private static <T extends LivingEntity> void maybeGrantUneasyAlliance(T dead, ServerPlayer player, DamageSource damageSource, Advancement advancement) {
        if (dead instanceof _SpecialGhastEntity && dead.m_9236_().m_46472_().equals((Object)Level.f_46428_)) {
            player.m_8960_().m_135988_(advancement, "killed_ghast");
        }
    }

    private boolean notCompleted(ServerPlayer player, @Nullable Advancement advancement) {
        if (advancement == null) {
            return false;
        }
        return !player.m_8960_().m_135996_(advancement).m_8193_();
    }

    @Nullable
    private Advancement getFromId(ResourceLocation advancementId) {
        return this.manager.m_136041_(advancementId);
    }
}

