/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombifiedpiglin;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.zombifiedpiglin._SpecialZombifiedPiglinEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class VampireZombifiedPiglinEntity
extends _SpecialZombifiedPiglinEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<VampireZombifiedPiglinEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureBaseOnly().addExperience(4).addToAttribute(Attributes.f_22276_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Vampire Piglin", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        VampireZombifiedPiglinEntity.addBaseLoot(loot);
        loot.addSemicommonDrop("semicommon", (ItemLike)Items.f_42692_);
        ItemStack stake = new ItemStack((ItemLike)Items.f_42420_);
        stake.m_41663_(Enchantments.f_44978_, Enchantments.f_44978_.m_6586_() * 2);
        loot.addRareDrop("rare", stake);
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of();
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<VampireZombifiedPiglinEntity> getVariantFactory() {
        return VampireZombifiedPiglinEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends VampireZombifiedPiglinEntity> getSpecies() {
        return SPECIES;
    }

    public VampireZombifiedPiglinEntity(EntityType<? extends _SpecialZombifiedPiglinEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, MobEffects.f_19602_, 2);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (MobHelper.isDamageSourceIneffectiveAgainstVampires(source)) {
            amount = Math.min(2.0f, amount);
        }
        return super.m_6469_(source, amount);
    }
}

