/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.MadScientistZombieSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.IAmmoUser;
import fathertoast.specialmobs.common.entity.ai.goal.ChargeCreeperGoal;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

@SpecialMob
public class MadScientistZombieEntity
extends _SpecialZombieEntity
implements IAmmoUser {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<MadScientistZombieEntity> SPECIES;
    private static final BiPredicate<MadScientistZombieEntity, ? super Creeper> CHARGE_CREEPER_TARGET;
    private int chargeCount;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14603462).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.STORM).uniqueTextureBaseOnly().addExperience(2).disableRangedAttack();
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new MadScientistZombieSpeciesConfig(manager, species, 0.0, 0.0, 1, 3);
    }

    @Override
    public MadScientistZombieSpeciesConfig getConfig() {
        return (MadScientistZombieSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Mad Scientist Zombie", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        MadScientistZombieEntity.addBaseLoot(loot);
        loot.addRareDrop("rare", (ItemLike)SMItems.SYRINGE.get());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<MadScientistZombieEntity> getVariantFactory() {
        return MadScientistZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends MadScientistZombieEntity> getSpecies() {
        return SPECIES;
    }

    public MadScientistZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, Level level) {
        super(entityType, level);
        this.chargeCount = this.getConfig().MAD_SCIENTIST.chargeCount.next(this.f_19796_);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.f_21345_, 2, new ChargeCreeperGoal<MadScientistZombieEntity>(this, 1.25, 20.0, CHARGE_CREEPER_TARGET));
    }

    @Override
    protected int getVariantAttackPriority() {
        return super.getVariantAttackPriority() + 1;
    }

    @Override
    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)SMItems.SYRINGE.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        if (this.hasAmmo()) {
            MobHelper.applyEffect(target, MobEffects.f_19614_);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.chargeCount <= 0 && this.m_6844_(EquipmentSlot.MAINHAND).m_41720_() == SMItems.SYRINGE.get()) {
            this.m_21166_(EquipmentSlot.MAINHAND);
            this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        }
    }

    @Override
    public boolean hasAmmo() {
        return this.chargeCount > 0;
    }

    @Override
    public void consumeAmmo() {
        --this.chargeCount;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Ammo", (byte)this.chargeCount);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Ammo", 99)) {
            this.chargeCount = saveTag.m_128445_("Ammo");
        }
    }

    static {
        CHARGE_CREEPER_TARGET = (madman, creeper) -> creeper.m_6084_() && !creeper.m_7090_() && madman.m_21574_().m_148306_((Entity)creeper);
    }
}

