/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.zombie;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.HuskZombieSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.zombie._SpecialZombieEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

@SpecialMob
public class HuskZombieEntity
extends _SpecialZombieEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<HuskZombieEntity> SPECIES;
    private static final Predicate<MobFamily.Species<?>> HUSK_CONVERSION_SELECTOR;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(15125652).modBaseTexture("textures/entity/zombie/base_husk.png").weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.DESERT).size(1.0625f, 0.6f, 1.95f).addExperience(1);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new HuskZombieSpeciesConfig(manager, species, 0.05, 0.02);
    }

    @Override
    public HuskZombieSpeciesConfig getConfig() {
        return (HuskZombieSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_34328_() {
        return Husk.m_34328_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends HuskZombieEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, HuskZombieEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends HuskZombieEntity> type, ServerLevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return NaturalSpawnManager.checkSpawnRulesDefault(type, world, spawnType, pos, random) && (spawnType == MobSpawnType.SPAWNER || world.m_45527_(pos));
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Husk", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20458_.m_20677_());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<HuskZombieEntity> getVariantFactory() {
        return HuskZombieEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends HuskZombieEntity> getSpecies() {
        return SPECIES;
    }

    public HuskZombieEntity(EntityType<? extends _SpecialZombieEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19612_);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, MobEffects.f_19612_);
    }

    @Override
    protected void m_7595_() {
        this.m_34310_(this.getVariantConversionType());
        References.LevelEvent.HUSK_CONVERTED_TO_ZOMBIE.play((Entity)this);
    }

    @Override
    protected EntityType<? extends Zombie> getVariantConversionType() {
        return this.getConfig().HUSK.convertVariantChance.rollChance(this.f_19796_, this.m_9236_(), this.m_20183_()) ? (EntityType)MobFamily.ZOMBIE.nextVariant((Level)this.m_9236_(), (BlockPos)this.m_20183_(), HuskZombieEntity.HUSK_CONVERSION_SELECTOR, _SpecialZombieEntity.SPECIES).entityType.get() : (EntityType)_SpecialZombieEntity.SPECIES.entityType.get();
    }

    @Override
    protected boolean m_5884_() {
        return false;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12043_;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12046_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12045_;
    }

    protected SoundEvent m_7660_() {
        return SoundEvents.f_12047_;
    }

    static {
        HUSK_CONVERSION_SELECTOR = species -> species != SPECIES && !species.config.GENERAL.isDamagedByWater.get();
    }
}

