/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witherskeleton;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.witherskeleton._SpecialWitherSkeletonEntity;
import fathertoast.specialmobs.common.event.PlayerVelocityWatcher;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class SniperWitherSkeletonEntity
extends _SpecialWitherSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SniperWitherSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(4744992).uniqueTextureWithOverlay().addExperience(1).multiplyRangedSpread(0.05).multiplyRangedWalkSpeed(0.3).multiplyRangedCooldown(1.5f).rangedMaxRange(25.0).addToAttribute(Attributes.f_22281_, 2.0).addToRangedDamage(4.0).addToAttribute(Attributes.f_22277_, 16.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(manager, species, 1.0, 0.05);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Sniper Wither Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SniperWitherSkeletonEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (ItemLike)Items.f_42412_, 1);
        loot.addClusterDrop("uncommon", (ItemLike)Items.f_42737_, 4);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<SniperWitherSkeletonEntity> getVariantFactory() {
        return SniperWitherSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SniperWitherSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public SniperWitherSkeletonEntity(EntityType<? extends _SpecialWitherSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_6504_(LivingEntity target, float damageMulti) {
        double g = 0.05;
        float v = 1.6f;
        double dist = this.m_20270_((Entity)target);
        double arcFactor = dist * 0.012;
        float ticksToTarget = (float)(dist / (double)1.6f * (1.0 + arcFactor * arcFactor * arcFactor));
        Vec3 targetV = PlayerVelocityWatcher.getVelocity((Entity)target);
        double dX = target.m_20185_() + targetV.f_82479_ * (double)ticksToTarget - this.m_20185_();
        double dY = target.m_20227_(0.5) - this.m_20188_() + 0.1;
        double dZ = target.m_20189_() + targetV.f_82481_ * (double)ticksToTarget - this.m_20189_();
        double dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        double radical = 6.553600311279297 - 0.05 * (0.05 * dH * dH + 2.0 * dY * (double)1.6f * (double)1.6f);
        if (radical < 0.0) {
            super.m_6504_(target, damageMulti);
            return;
        }
        double angle = Math.atan((2.56000018119812 - Math.sqrt(radical)) / (0.05 * dH));
        double vY = Math.sin(angle);
        double vH = Math.cos(angle);
        ItemStack arrowItem = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof BowItem)));
        AbstractArrow arrow = this.m_7932_(arrowItem, damageMulti);
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            arrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(arrow);
        }
        arrow.m_6686_(dX / dH * vH, vY, dZ / dH * vH, 1.6f, this.getSpecialData().getRangedAttackSpread() * (float)(14 - 4 * this.m_9236_().m_46791_().m_19028_()));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        arrow.m_36735_(arrow.m_150123_() + 2);
        return arrow;
    }
}

