/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.witherskeleton;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SkeletonSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.INinja;
import fathertoast.specialmobs.common.entity.ai.goal.NinjaGoal;
import fathertoast.specialmobs.common.entity.witherskeleton._SpecialWitherSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class NinjaWitherSkeletonEntity
extends _SpecialWitherSkeletonEntity
implements INinja {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<NinjaWitherSkeletonEntity> SPECIES;
    private static final EntityDataAccessor<Boolean> IS_HIDING;
    private static final EntityDataAccessor<Optional<BlockState>> HIDING_BLOCK;
    private boolean canHide = true;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x333366).modBaseTexture("textures/entity/wither_skeleton/base_wither_skeleton.png").uniqueOverlayTexture().addExperience(2).pressurePlateImmune().multiplyRangedCooldown(0.5f).rangedMaxRange(9.0).multiplyAttribute(Attributes.f_22279_, 1.2);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SkeletonSpeciesConfig(manager, species, 0.5, 0.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Wither Skeleton Ninja", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        NinjaWitherSkeletonEntity.addBaseLoot(loot);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50226_, Blocks.f_50227_, Blocks.f_50176_, Blocks.f_50178_, Blocks.f_50177_, Blocks.f_50179_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<NinjaWitherSkeletonEntity> getVariantFactory() {
        return NinjaWitherSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends NinjaWitherSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public NinjaWitherSkeletonEntity(EntityType<? extends _SpecialWitherSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerVariantGoals() {
        this.f_21345_.m_25352_(-9, new NinjaGoal<NinjaWitherSkeletonEntity>(this));
    }

    @Override
    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.m_21553_(true);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        this.revealTo(target, true);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            if (source.m_7639_() instanceof LivingEntity) {
                this.revealTo((LivingEntity)source.m_7639_(), false);
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_() && this.getHiddenDragon() != null) {
            this.revealTo((LivingEntity)player, true);
        }
        return super.m_6071_(player, hand);
    }

    public void m_6123_(Player player) {
        if (!this.m_9236_().m_5776_() && this.getHiddenDragon() != null && !player.m_7500_()) {
            this.revealTo((LivingEntity)player, true);
        }
        super.m_6123_(player);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            Player player;
            LivingEntity livingEntity;
            if (this.canHide) {
                this.setHiddenDragon(NinjaGoal.pickDisguise(this));
            } else if (this.m_20096_() && this.getHiddenDragon() == null && (this.m_5448_() == null || (livingEntity = this.m_5448_()) instanceof Player && (player = (Player)livingEntity).m_7500_())) {
                this.canHide = true;
            }
        }
        super.m_8119_();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
    }

    protected SoundEvent m_7515_() {
        return this.isCrouchingTiger() ? null : super.m_7515_();
    }

    public void m_7678_(double x, double y, double z, float yaw, float pitch) {
        if (!this.isCrouchingTiger()) {
            super.m_7678_(x, y, z, yaw, pitch);
        }
    }

    public void m_20256_(Vec3 vec) {
        if (!this.isCrouchingTiger()) {
            super.m_20256_(vec);
        }
    }

    public boolean m_6094_() {
        return super.m_6094_() && !this.isCrouchingTiger();
    }

    @Override
    public void m_7311_(int ticks) {
        if (!this.isCrouchingTiger()) {
            super.m_7311_(ticks);
        }
    }

    public void revealTo(LivingEntity target, boolean ambush) {
        Player player;
        if (this.getHiddenDragon() == null) {
            return;
        }
        this.setHiddenDragon(null);
        if (!(target instanceof Player) || !(player = (Player)target).m_7500_()) {
            this.m_6710_(target);
            if (ambush) {
                MobHelper.applyEffect(target, MobEffects.f_19614_);
                MobHelper.applyEffect(target, MobEffects.f_19597_);
                MobHelper.applyEffect(target, MobEffects.f_19610_);
                MobHelper.removeNightVision(target);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_HIDING, (Object)false);
        this.f_19804_.m_135372_(HIDING_BLOCK, Optional.empty());
    }

    @Override
    public boolean isCrouchingTiger() {
        return (Boolean)this.m_20088_().m_135370_(IS_HIDING);
    }

    @Override
    public void setCrouchingTiger(boolean value) {
        if (value != this.isCrouchingTiger()) {
            this.m_20088_().m_135381_(IS_HIDING, (Object)value);
        }
    }

    @Override
    @Nullable
    public BlockState getHiddenDragon() {
        if (this.m_6084_()) {
            return ((Optional)this.m_20088_().m_135370_(HIDING_BLOCK)).orElse(null);
        }
        return null;
    }

    @Override
    public void setHiddenDragon(@Nullable BlockState block) {
        this.m_20088_().m_135381_(HIDING_BLOCK, Optional.ofNullable(block));
        this.canHide = false;
        if (block == null) {
            this.m_21373_();
        }
    }

    static {
        IS_HIDING = SynchedEntityData.m_135353_(NinjaWitherSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        HIDING_BLOCK = SynchedEntityData.m_135353_(NinjaWitherSkeletonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_268618_);
    }
}

